/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image;

import adams.core.base.BaseRegExp;
import adams.core.base.BaseString;
import adams.core.option.AbstractOptionHandler;
import adams.data.report.AbstractField;
import adams.data.report.Report;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import adams.gui.core.Fonts;
import adams.gui.visualization.core.ColorProvider;
import adams.gui.visualization.core.DefaultColorProvider;
import java.awt.Color;
import java.awt.Font;
import java.awt.Polygon;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class ReportObjectOverlay
extends AbstractOptionHandler {
    private static final long serialVersionUID = 6356419097401574024L;
    public static final String PREFIX_DEFAULT = "Object.";
    protected String m_Prefix;
    protected Color m_Color;
    protected boolean m_UseColorsPerType;
    protected ColorProvider m_TypeColorProvider;
    protected String m_TypeSuffix;
    protected BaseRegExp m_TypeRegExp;
    protected String m_LabelFormat;
    protected Font m_LabelFont;
    protected int m_LabelOffsetX;
    protected int m_LabelOffsetY;
    protected List<Polygon> m_Locations;
    protected HashMap<String, Color> m_TypeColors;
    protected HashMap<Polygon, Color> m_Colors;
    protected HashMap<Polygon, String> m_Labels;
    protected BaseString[] m_PredefinedLabels;

    public String globalInfo() {
        return "Computes colors and labels for objects in report.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("prefix", "prefix", (Object)PREFIX_DEFAULT);
        this.m_OptionManager.add("color", "color", (Object)Color.RED);
        this.m_OptionManager.add("use-colors-per-type", "useColorsPerType", (Object)false);
        this.m_OptionManager.add("type-color-provider", "typeColorProvider", (Object)new DefaultColorProvider());
        this.m_OptionManager.add("type-suffix", "typeSuffix", (Object)".type");
        this.m_OptionManager.add("type-regexp", "typeRegExp", (Object)new BaseRegExp(".*"));
        this.m_OptionManager.add("label-format", "labelFormat", (Object)"#");
        this.m_OptionManager.add("label-font", "labelFont", (Object)Fonts.getSansFont((int)14));
        this.m_OptionManager.add("label-offset-x", "labelOffsetX", (Object)0);
        this.m_OptionManager.add("label-offset-y", "labelOffsetY", (Object)0);
        this.m_OptionManager.add("predefined-labels", "predefinedLabels", (Object)new BaseString[0]);
    }

    public void reset() {
        super.reset();
        this.m_Locations = null;
        this.m_TypeColors = new HashMap();
        this.m_Colors = new HashMap();
        this.m_Labels = new HashMap();
    }

    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The prefix of fields in the report to identify as object location, eg 'Object.'.";
    }

    public void setColor(Color value) {
        this.m_Color = value;
        this.reset();
    }

    public Color getColor() {
        return this.m_Color;
    }

    public String colorTipText() {
        return "The color to use for the objects.";
    }

    public void setUseColorsPerType(boolean value) {
        this.m_UseColorsPerType = value;
        this.reset();
    }

    public boolean getUseColorsPerType() {
        return this.m_UseColorsPerType;
    }

    public String useColorsPerTypeTipText() {
        return "If enabled, individual colors per type are used.";
    }

    public void setTypeColorProvider(ColorProvider value) {
        this.m_TypeColorProvider = value;
        this.reset();
    }

    public ColorProvider getTypeColorProvider() {
        return this.m_TypeColorProvider;
    }

    public String typeColorProviderTipText() {
        return "The color provider to use for the various types.";
    }

    public void setTypeSuffix(String value) {
        this.m_TypeSuffix = value;
        this.reset();
    }

    public String getTypeSuffix() {
        return this.m_TypeSuffix;
    }

    public String typeSuffixTipText() {
        return "The suffix of fields in the report to identify the type.";
    }

    public void setTypeRegExp(BaseRegExp value) {
        this.m_TypeRegExp = value;
        this.reset();
    }

    public BaseRegExp getTypeRegExp() {
        return this.m_TypeRegExp;
    }

    public String typeRegExpTipText() {
        return "The regular expression that the types must match in order to get drawn (eg only plotting a subset).";
    }

    public void setLabelFormat(String value) {
        this.m_LabelFormat = value;
        this.reset();
    }

    public String getLabelFormat() {
        return this.m_LabelFormat;
    }

    public String labelFormatTipText() {
        return "The label format string to use for the rectangles; '#' for index, '@' for type and '$' for short type (type suffix must be defined for '@' and '$'); for instance: '# @'.";
    }

    public void setLabelFont(Font value) {
        this.m_LabelFont = value;
        this.reset();
    }

    public Font getLabelFont() {
        return this.m_LabelFont;
    }

    public String labelFontTipText() {
        return "The font to use for the labels.";
    }

    public void setLabelOffsetX(int value) {
        this.m_LabelOffsetX = value;
        this.reset();
    }

    public int getLabelOffsetX() {
        return this.m_LabelOffsetX;
    }

    public String labelOffsetXTipText() {
        return "The X offset for the label.";
    }

    public void setLabelOffsetY(int value) {
        this.m_LabelOffsetY = value;
        this.reset();
    }

    public int getLabelOffsetY() {
        return this.m_LabelOffsetY;
    }

    public String labelOffsetYTipText() {
        return "The Y offset for the label.";
    }

    public void setPredefinedLabels(BaseString[] value) {
        this.m_PredefinedLabels = value;
        this.reset();
    }

    public BaseString[] getPredefinedLabels() {
        return this.m_PredefinedLabels;
    }

    public String predefinedLabelsTipText() {
        return "The predefined labels to use for setting up the colors; avoids constants changing in color pallet.";
    }

    public void determineLocations(Report report) {
        if (this.m_Locations != null) {
            return;
        }
        if (report == null) {
            return;
        }
        if (this.m_UseColorsPerType) {
            this.m_TypeColors.clear();
            this.m_TypeColorProvider.resetColors();
            HashSet<String> types = new HashSet<String>();
            for (BaseString predefined : this.m_PredefinedLabels) {
                this.m_TypeColors.put(predefined.getValue(), this.m_TypeColorProvider.next());
            }
            for (AbstractField field : report.getFields()) {
                if (!field.getName().endsWith(this.m_TypeSuffix)) continue;
                types.add("" + report.getValue(field));
            }
            for (String t : types) {
                if (this.m_TypeColors.containsKey(t)) continue;
                this.m_TypeColors.put(t, this.m_TypeColorProvider.next());
            }
        }
        this.m_Locations = new ArrayList<Polygon>();
        this.m_Colors = new HashMap();
        this.m_Labels = new HashMap();
        String suffix = this.m_TypeSuffix.isEmpty() ? "" : this.m_TypeSuffix.substring(1);
        LocatedObjects located = LocatedObjects.fromReport(report, this.m_Prefix);
        for (LocatedObject object : located) {
            String label;
            Polygon poly;
            if (object.hasPolygon()) {
                poly = object.getPolygon();
            } else {
                int[] poly_x = new int[]{object.getX(), object.getX() + object.getWidth() - 1, object.getX() + object.getWidth() - 1, object.getX()};
                int[] poly_y = new int[]{object.getY(), object.getY(), object.getY() + object.getHeight() - 1, object.getY() + object.getHeight() - 1};
                poly = new Polygon(poly_x, poly_y, poly_x.length);
            }
            Color color = this.m_Color;
            if (!suffix.isEmpty() && object.getMetaData() != null && object.getMetaData().containsKey(suffix)) {
                String type = "" + object.getMetaData().get(suffix);
                if (!this.m_TypeRegExp.isMatchAll() && !this.m_TypeRegExp.isMatch(type)) continue;
                if (this.m_UseColorsPerType && this.m_TypeColors.containsKey(type)) {
                    color = this.m_TypeColors.get(type);
                }
                if (!this.m_LabelFormat.isEmpty()) {
                    label = this.m_LabelFormat.replace("#", "" + object.getMetaData().get("index")).replace("@", type).replace("$", type.replaceAll(".*\\.", ""));
                    this.m_Labels.put(poly, label);
                }
            } else if (!this.m_LabelFormat.isEmpty()) {
                label = this.m_LabelFormat.replace("#", "" + object.getMetaData().get("index")).replace("@", "").replace("$", "");
                this.m_Labels.put(poly, label);
            }
            this.m_Colors.put(poly, color);
            this.m_Locations.add(poly);
        }
    }

    public boolean hasColor(Polygon poly) {
        return this.m_Colors.containsKey(poly);
    }

    public Color getColor(Polygon poly) {
        return this.m_Colors.get(poly);
    }

    public boolean hasTypeColor(String type) {
        return this.m_UseColorsPerType && this.m_Colors.containsKey(type);
    }

    public Color getTypeColor(String type) {
        return this.m_TypeColors.get(type);
    }

    public boolean hasLabel(Polygon poly) {
        return !this.m_LabelFormat.isEmpty() && this.m_Labels.containsKey(poly);
    }

    public String getLabel(Polygon poly) {
        return this.m_Labels.get(poly);
    }

    public boolean hasLocations() {
        return this.m_Locations != null && this.m_Locations.size() > 0;
    }

    public List<Polygon> getLocations() {
        return this.m_Locations;
    }
}

