/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image.leftclick;

import adams.core.Randomizable;
import adams.core.Utils;
import adams.core.base.BaseInterval;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.SelectionRectangle;
import adams.gui.visualization.image.leftclick.AbstractSelectionRectangleBasedLeftClickProcessor;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Random;

public class RandomBoundingBox
extends AbstractSelectionRectangleBasedLeftClickProcessor
implements Randomizable {
    private static final long serialVersionUID = 4069769951854697560L;
    protected long m_Seed;
    protected BaseInterval m_RangeWidth;
    protected BaseInterval m_RangeHeight;
    protected Random m_Random;

    public String globalInfo() {
        return "Allows the user to create randomly sized bounding boxes around the left-click position (<ctrl> left-click in box removes it).";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("seed", "seed", (Object)1L);
        this.m_OptionManager.add("range-width", "rangeWidth", (Object)new BaseInterval(10.0, 50.0));
        this.m_OptionManager.add("range-height", "rangeHeight", (Object)new BaseInterval(10.0, 50.0));
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_Random = null;
    }

    public void setSeed(long value) {
        this.m_Seed = value;
        this.reset();
    }

    public long getSeed() {
        return this.m_Seed;
    }

    public String seedTipText() {
        return "The seed value for the random bounding boxes.";
    }

    public void setRangeWidth(BaseInterval value) {
        this.m_RangeWidth = value;
        this.reset();
    }

    public BaseInterval getRangeWidth() {
        return this.m_RangeWidth;
    }

    public String rangeWidthTipText() {
        return "The range of pixels for the bounding box width.";
    }

    public void setRangeHeight(BaseInterval value) {
        this.m_RangeHeight = value;
        this.reset();
    }

    public BaseInterval getRangeHeight() {
        return this.m_RangeHeight;
    }

    public String rangeHeightTipText() {
        return "The range of pixels for the bounding box height.";
    }

    protected void doProcessClick(ImagePanel panel, Point position, int modifiersEx) {
        Report report = panel.getAdditionalProperties().getClone();
        if (this.m_Locations == null) {
            this.m_Locations = this.getLocations(report);
        }
        if (this.m_Random == null) {
            this.m_Random = new Random(this.m_Seed);
        }
        int x = panel.mouseToPixelLocation((Point)position).x;
        int y = panel.mouseToPixelLocation((Point)position).y;
        ArrayList<SelectionRectangle> queue = new ArrayList<SelectionRectangle>();
        boolean modified = false;
        if ((modifiersEx & 0x80) != 0) {
            for (SelectionRectangle r : this.m_Locations) {
                if (!r.contains(x, y)) continue;
                modified = true;
                String current = this.m_Prefix + Utils.padLeft((String)("" + r.getIndex()), (char)'0', (int)this.m_NumDigits);
                report.removeValue((AbstractField)new Field(current + ".x", DataType.NUMERIC));
                report.removeValue((AbstractField)new Field(current + ".y", DataType.NUMERIC));
                report.removeValue((AbstractField)new Field(current + ".width", DataType.NUMERIC));
                report.removeValue((AbstractField)new Field(current + ".height", DataType.NUMERIC));
                queue.add(r);
            }
            this.m_Locations.removeAll(queue);
        } else {
            int h;
            int w = (int)(this.m_RangeWidth.getLower() + this.m_Random.nextDouble() * (this.m_RangeWidth.getUpper() - this.m_RangeWidth.getLower()));
            SelectionRectangle rect = new SelectionRectangle(x - w / 2, y - (h = (int)(this.m_RangeHeight.getLower() + this.m_Random.nextDouble() * (this.m_RangeHeight.getUpper() - this.m_RangeHeight.getLower()))) / 2, w, h);
            if (!this.m_Locations.contains(rect)) {
                modified = true;
                int lastIndex = this.findLastIndex(report);
                String current = this.m_Prefix + Utils.padLeft((String)("" + (lastIndex + 1)), (char)'0', (int)this.m_NumDigits);
                report.setNumericValue(current + ".x", rect.getX());
                report.setNumericValue(current + ".y", rect.getY());
                report.setNumericValue(current + ".width", rect.getWidth());
                report.setNumericValue(current + ".height", rect.getHeight());
                this.m_Locations.add(rect);
            }
        }
        if (modified) {
            panel.setAdditionalProperties(report);
        }
    }
}

