/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image.selection;

import adams.core.base.BaseRegExp;
import adams.data.report.AbstractField;
import adams.data.report.Report;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.SelectionRectangle;
import adams.gui.visualization.image.selection.AbstractPaintingSelectionProcessor;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractSelectionRectangleBasedSelectionProcessor
extends AbstractPaintingSelectionProcessor {
    private static final long serialVersionUID = -5879410661391670242L;
    public static final String KEY_X = ".x";
    public static final String KEY_Y = ".y";
    public static final String KEY_WIDTH = ".width";
    public static final String KEY_HEIGHT = ".height";
    public static final String KEY_POLY_X = ".poly_x";
    public static final String KEY_POLY_Y = ".poly_y";
    protected String m_Prefix;
    protected int m_NumDigits;
    protected List<SelectionRectangle> m_Locations;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("prefix", "prefix", (Object)this.getDefaultPrefix());
        this.m_OptionManager.add("num-digits", "numDigits", (Object)this.getDefaultNumDigits(), (Number)0, null);
    }

    protected void reset() {
        super.reset();
        this.m_Locations = null;
    }

    protected String getDefaultPrefix() {
        return "Object.";
    }

    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The prefix to use for the fields in the report.";
    }

    protected int getDefaultNumDigits() {
        return 4;
    }

    public void setNumDigits(int value) {
        this.m_NumDigits = value;
        this.reset();
    }

    public int getNumDigits() {
        return this.m_NumDigits;
    }

    public String numDigitsTipText() {
        return "The number of digits to use for left-padding the index with zeroes.";
    }

    protected boolean removeIndex(Report report, int index) {
        boolean result = false;
        BaseRegExp regexp = new BaseRegExp(this.m_Prefix + "[0]*" + index + "\\..*");
        ArrayList<AbstractField> remove = new ArrayList<AbstractField>();
        for (AbstractField field : report.getFields()) {
            if (!regexp.isMatch(field.getName())) continue;
            remove.add(field);
        }
        if (remove.size() > 0) {
            result = true;
            for (AbstractField field : remove) {
                report.removeValue(field);
            }
        }
        return result;
    }

    protected int findLastIndex(Report report) {
        int result = 0;
        List fields = report.getFields();
        for (AbstractField field : fields) {
            if (!field.getName().startsWith(this.m_Prefix)) continue;
            String name = field.getName().substring(this.m_Prefix.length());
            if (name.indexOf(46) > -1) {
                name = name.substring(0, name.indexOf(46));
            }
            try {
                int current = Integer.parseInt(name);
                if (current <= result) continue;
                result = current;
            }
            catch (Exception exception) {}
        }
        return result;
    }

    protected List<SelectionRectangle> getLocations(Report report) {
        ArrayList<SelectionRectangle> result = new ArrayList<SelectionRectangle>();
        List fields = report.getFields();
        for (AbstractField field : fields) {
            if (!field.getName().startsWith(this.m_Prefix)) continue;
            String name = field.getName().substring(this.m_Prefix.length());
            if (name.indexOf(46) > -1) {
                name = name.substring(0, name.indexOf(46));
            }
            try {
                SelectionRectangle rect = new SelectionRectangle(report.getDoubleValue(this.m_Prefix + name + KEY_X).intValue(), report.getDoubleValue(this.m_Prefix + name + KEY_Y).intValue(), report.getDoubleValue(this.m_Prefix + name + KEY_WIDTH).intValue(), report.getDoubleValue(this.m_Prefix + name + KEY_HEIGHT).intValue(), Integer.parseInt(name));
                if (result.contains(rect)) continue;
                result.add(rect);
            }
            catch (Exception exception) {}
        }
        return result;
    }

    protected void doImageChanged(ImagePanel.PaintPanel panel) {
        this.m_Locations = null;
    }
}

