/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image.selection;

import adams.core.Utils;
import adams.data.report.Report;
import adams.data.statistics.StatUtils;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.SelectionRectangle;
import adams.gui.visualization.image.selection.AbstractSelectionRectangleBasedSelectionProcessor;
import adams.gui.visualization.image.selection.SelectionProcessorWithLabelSupport;
import java.awt.Color;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

public class SelectObjects
extends AbstractSelectionRectangleBasedSelectionProcessor
implements SelectionProcessorWithLabelSupport {
    private static final long serialVersionUID = -5879410661391670242L;
    protected String m_Label;
    protected String m_LabelSuffix;

    public String globalInfo() {
        return "Allows the user to select objects in the image.\nThe locations get stored in the attached report.\nIf the <ctrl> key is pressed while drawing a selection rectangle, all enclosed locations get removed.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("label", "label", (Object)this.getDefaultLabel());
        this.m_OptionManager.add("label-suffix", "labelSuffix", (Object)this.getDefaultLabelSuffix());
    }

    protected String getDefaultLabel() {
        return "";
    }

    @Override
    public void setLabel(String value) {
        this.m_Label = value;
        this.reset();
    }

    @Override
    public String getLabel() {
        return this.m_Label;
    }

    @Override
    public String labelTipText() {
        return "The label to use for the objects, not set if empty.";
    }

    protected String getDefaultLabelSuffix() {
        return ".type";
    }

    @Override
    public void setLabelSuffix(String value) {
        this.m_LabelSuffix = value;
        this.reset();
    }

    @Override
    public String getLabelSuffix() {
        return this.m_LabelSuffix;
    }

    @Override
    public String labelSuffixTipText() {
        return "The suffix to use for storing the label in the report.";
    }

    @Override
    protected Color getDefaultColor() {
        return Color.RED;
    }

    protected void doProcessSelection(ImagePanel panel, Point topLeft, Point bottomRight, List<Point> trace, int modifiersEx) {
        int h;
        int w;
        int y;
        int x;
        Report report = panel.getAdditionalProperties().getClone();
        if (this.m_Locations == null) {
            this.m_Locations = this.getLocations(report);
        }
        Polygon poly = null;
        if (trace.size() > 0) {
            poly = panel.traceToPolygon(trace);
            Rectangle bounds = poly.getBounds();
            x = (int)bounds.getX();
            y = (int)bounds.getY();
            w = (int)bounds.getWidth();
            h = (int)bounds.getHeight();
        } else {
            x = panel.mouseToPixelLocation((Point)topLeft).x;
            y = panel.mouseToPixelLocation((Point)topLeft).y;
            w = panel.mouseToPixelLocation((Point)bottomRight).x - panel.mouseToPixelLocation((Point)topLeft).x + 1;
            h = panel.mouseToPixelLocation((Point)bottomRight).y - panel.mouseToPixelLocation((Point)topLeft).y + 1;
        }
        SelectionRectangle rect = new SelectionRectangle(x, y, w, h, -1);
        ArrayList<SelectionRectangle> queue = new ArrayList<SelectionRectangle>();
        boolean modified = false;
        if ((modifiersEx & 0x80) != 0) {
            for (SelectionRectangle r : this.m_Locations) {
                if (!rect.contains(r) || !this.removeIndex(report, r.getIndex())) continue;
                modified = true;
                queue.add(r);
            }
            this.m_Locations.removeAll(queue);
        } else if (!this.m_Locations.contains(rect)) {
            modified = true;
            int lastIndex = this.findLastIndex(report);
            String current = this.m_Prefix + Utils.padLeft((String)("" + (lastIndex + 1)), (char)'0', (int)this.m_NumDigits);
            report.setNumericValue(current + ".x", (double)x);
            report.setNumericValue(current + ".y", (double)y);
            report.setNumericValue(current + ".width", (double)w);
            report.setNumericValue(current + ".height", (double)h);
            if (poly != null) {
                int[] poly_x = new int[trace.size()];
                int[] poly_y = new int[trace.size()];
                for (int i = 0; i < trace.size(); ++i) {
                    poly_x[i] = (int)panel.mouseToPixelLocation(trace.get(i)).getX();
                    poly_y[i] = (int)panel.mouseToPixelLocation(trace.get(i)).getY();
                }
                report.setStringValue(current + ".poly_x", Utils.flatten((Object[])StatUtils.toNumberArray((int[])poly_x), (String)","));
                report.setStringValue(current + ".poly_y", Utils.flatten((Object[])StatUtils.toNumberArray((int[])poly_y), (String)","));
            }
            if (!this.m_Label.isEmpty()) {
                report.setStringValue(current + this.m_LabelSuffix, this.m_Label);
            }
            this.m_Locations.add(rect);
        }
        if (modified) {
            panel.setAdditionalProperties(report);
        }
    }
}

