/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.features.global;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.WritableRaster;
import net.semanticmetadata.lire.imageanalysis.features.LireFeature;
import net.semanticmetadata.lire.utils.ImageUtils;

public class BasicFeatures
implements LireFeature {
    private static final int SIZE = 1024;
    private static final int BINS = 20;
    private static final float threshold = 0.05f;
    private float brightness = 0.0f;
    private float clipping = 0.0f;
    private float contrast = 0.0f;
    private float hueCount = 0.0f;
    private float saturation = 0.0f;
    private float complexity = 0.0f;
    private float skew = 0.0f;
    private float energy = 0.0f;

    public void extract(BufferedImage bimg) {
        BufferedImage sml = ImageUtils.scaleImage((BufferedImage)bimg, (int)1024);
        WritableRaster raster = sml.getRaster();
        int bands = raster.getNumBands();
        int clipB = 0;
        int clipD = 0;
        float average = 0.0f;
        float sum = 0.0f;
        int[] hist = new int[20];
        int[] hist256 = new int[256];
        int max = 0;
        if (bands == 3) {
            int i;
            int w = raster.getWidth();
            int h = raster.getHeight();
            int numPixels = w * h;
            int[] pixels = raster.getPixels(0, 0, w, h, new int[numPixels * bands]);
            int[] gPixels = new int[numPixels];
            for (int i2 = 0; i2 < w * h * bands; i2 += bands) {
                int grey = (pixels[i2] + pixels[i2 + 1] + pixels[i2 + 2]) / 3;
                float[] hsv = new float[3];
                this.brightness += (float)grey / 255.0f;
                int cornerSum = pixels[0] + pixels[1] + pixels[2] + pixels[w * h * 3 - 3] + pixels[w * h * 3 - 2] + pixels[w * h * 3 - 1];
                if (cornerSum != 0 && cornerSum != 1530) {
                    if (grey == 255) {
                        ++clipB;
                    } else if (grey == 0) {
                        ++clipD;
                    }
                }
                gPixels[i2 / 3] = grey;
                sum += (float)grey;
                int n = grey;
                hist256[n] = hist256[n] + 1;
                Color.RGBtoHSB(pixels[i2], pixels[i2 + 1], pixels[i2 + 2], hsv);
                if ((double)hsv[2] > 0.15 && (double)hsv[2] < 0.95 && (double)hsv[1] > 0.2) {
                    int n2 = (int)(hsv[0] * 20.0f);
                    hist[n2] = hist[n2] + 1;
                }
                this.saturation += hsv[1];
            }
            this.complexity = this.getComplexity(bimg);
            this.clipping = (float)(clipB + clipD / 2) / (float)numPixels;
            this.brightness /= (float)numPixels;
            average = sum / (float)numPixels;
            float dev = this.stdDeviation(gPixels, average);
            this.contrast = dev / 128.0f;
            for (i = 0; i < 20; ++i) {
                if (hist[i] <= max) continue;
                max = hist[i];
            }
            max = (int)((float)max * 0.05f);
            for (i = 0; i < 20; ++i) {
                if (hist[i] <= max) continue;
                this.hueCount += 1.0f;
            }
            this.hueCount /= 20.0f;
            for (i = 0; i < 256; ++i) {
                float temp = (float)hist256[i] / (float)(w * h);
                this.energy += temp * temp;
            }
            for (i = 0; i < 256; ++i) {
                float temp = (float)hist256[i] / (float)(w * h);
                float temp2 = (float)i - average;
                this.skew += temp2 * temp2 * temp2 * temp;
            }
            this.skew /= dev * dev * dev;
            this.saturation /= (float)numPixels;
        }
    }

    public byte[] getByteArrayRepresentation() {
        throw new UnsupportedOperationException("No implemented!");
    }

    public void setByteArrayRepresentation(byte[] in) {
        throw new UnsupportedOperationException("No implemented!");
    }

    public void setByteArrayRepresentation(byte[] in, int offset, int length) {
        throw new UnsupportedOperationException("No implemented!");
    }

    public double[] getFeatureVector() {
        double[] result = new double[]{this.brightness, this.clipping, this.contrast, this.hueCount, this.saturation, this.complexity, this.skew, this.energy};
        return result;
    }

    private float getComplexity(BufferedImage img) {
        BufferedImage sml = new BufferedImage(1024, 1024, 10);
        sml.getGraphics().drawImage(img, 0, 0, 1024, 1024, null);
        float ret = 0.0f;
        int w = sml.getWidth();
        int h = sml.getHeight();
        Kernel laplace = new Kernel(3, 3, new float[]{1.0f, 1.0f, 1.0f, 1.0f, -8.0f, 1.0f, 1.0f, 1.0f, 1.0f});
        ConvolveOp filter = new ConvolveOp(laplace);
        BufferedImage dest = filter.createCompatibleDestImage(sml, null);
        filter.filter(sml, dest);
        WritableRaster data = dest.getRaster();
        int[] pixels = data.getPixels(0, 0, w, h, new int[w * h]);
        int sum = 0;
        for (int i = 0; i < w; ++i) {
            for (int j = 0; j < h; ++j) {
                int temp = pixels[i + j * w];
                sum += temp;
            }
        }
        ret = (float)sum / (float)(w * h * 256);
        if ((double)ret < 0.01) {
            ret = 1.0f;
        }
        return ret;
    }

    private float stdDeviation(int[] input, float mean) {
        float sum = 0.0f;
        for (int i : input) {
            float temp = (float)i - mean;
            sum += temp * temp;
        }
        return (float)Math.sqrt(sum / (float)(input.length - 1));
    }

    public double getDistance(LireFeature arg0) {
        if (!(arg0 instanceof BasicFeatures)) {
            throw new UnsupportedOperationException("Wrong descriptor.");
        }
        BasicFeatures in = (BasicFeatures)arg0;
        float tmp = this.brightness - in.brightness;
        float dst = tmp * tmp;
        tmp = this.clipping - in.clipping;
        dst += tmp * tmp;
        tmp = this.contrast - in.contrast;
        dst += tmp * tmp;
        tmp = this.hueCount - in.hueCount;
        dst += tmp * tmp;
        tmp = this.saturation - in.saturation;
        dst += tmp * tmp;
        tmp = this.complexity - in.complexity;
        dst += tmp * tmp;
        tmp = this.skew - in.skew;
        dst += tmp * tmp;
        tmp = this.energy - in.energy;
        return (float)Math.sqrt(dst += tmp * tmp);
    }

    public String getStringRepresentation() {
        return this.brightness + " " + this.clipping + " " + this.contrast + " " + this.hueCount + " " + this.saturation + " " + this.complexity + " " + this.skew + " " + this.energy;
    }

    public void setStringRepresentation(String arg0) {
        String[] values = arg0.split(" ");
        this.brightness = Float.parseFloat(values[0]);
        this.clipping = Float.parseFloat(values[1]);
        this.contrast = Float.parseFloat(values[2]);
        this.hueCount = Float.parseFloat(values[3]);
        this.saturation = Float.parseFloat(values[4]);
        this.complexity = Float.parseFloat(values[5]);
        this.skew = Float.parseFloat(values[6]);
        this.energy = Float.parseFloat(values[7]);
    }

    public String getFeatureName() {
        return "BasicFeatures";
    }

    public String getFieldName() {
        return "f_baf";
    }
}

