/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image;

import adams.data.image.ImageMetaDataHelper;
import adams.data.io.output.CsvSpreadSheetWriter;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.RowComparator;
import adams.data.spreadsheet.SpreadSheet;
import adams.env.Environment;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.Regression;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class ImageMetaDataHelperTest
extends AdamsTestCase {
    public ImageMetaDataHelperTest(String name) {
        super(name);
    }

    protected AbstractTestHelper newTestHelper() {
        return new TestHelper((AdamsTestCase)this, "adams/data/image/data");
    }

    protected void removeKey(SpreadSheet sheet, String key) {
        for (int i = 0; i < sheet.getRowCount(); ++i) {
            Cell cell = sheet.getCell(i, 0);
            if (cell == null || cell.isMissing() || !cell.getContent().equals(key)) continue;
            sheet.removeRow(i);
            break;
        }
    }

    protected boolean save(SpreadSheet meta, String file) {
        RowComparator comp = new RowComparator(new int[]{0, 1});
        meta.sort(comp);
        CsvSpreadSheetWriter writer = new CsvSpreadSheetWriter();
        return writer.write(meta, (File)new TmpFile(file));
    }

    protected String[] getRegressionInput() {
        return new String[]{"3666455665_18795f0741.jpg", "ColorChecker100423.jpg"};
    }

    public void testGetMetaData() {
        Regression reg = new Regression(ImageMetaDataHelper.class);
        reg.setReferenceFile(Regression.createReferenceFile(ImageMetaDataHelper.class, (String)"-Sanselan"));
        String[] input = this.getRegressionInput();
        String[] output = new String[input.length];
        TmpFile[] regFiles = new TmpFile[input.length];
        for (int i = 0; i < input.length; ++i) {
            this.m_TestHelper.copyResourceToTmp(input[i]);
            output[i] = "out-" + i + ".csv";
            this.m_TestHelper.deleteFileFromTmp(output[i]);
            regFiles[i] = new TmpFile(output[i]);
            try {
                SpreadSheet meta = ImageMetaDataHelper.sanselan((File)new TmpFile(input[i]));
                this.removeKey(meta, "File Modified Date");
                this.save(meta, output[i]);
            }
            catch (Exception e) {
                ImageMetaDataHelperTest.fail((String)("Failed to extract meta-data from: " + input[i]));
            }
            this.m_TestHelper.deleteFileFromTmp(input[i]);
        }
        String diff = reg.compare((File[])regFiles);
        if (diff != null) {
            ImageMetaDataHelperTest.fail((String)diff);
        }
    }

    public void testGetMetaDataExtractor() {
        Regression reg = new Regression(ImageMetaDataHelper.class);
        reg.setReferenceFile(Regression.createReferenceFile(ImageMetaDataHelper.class, (String)"-MetaDataExtractor"));
        String[] input = this.getRegressionInput();
        String[] output = new String[input.length];
        TmpFile[] regFiles = new TmpFile[input.length];
        for (int i = 0; i < input.length; ++i) {
            this.m_TestHelper.copyResourceToTmp(input[i]);
            output[i] = "out-" + i + ".csv";
            this.m_TestHelper.deleteFileFromTmp(output[i]);
            regFiles[i] = new TmpFile(output[i]);
            try {
                SpreadSheet meta = ImageMetaDataHelper.metaDataExtractor((File)new TmpFile(input[i]));
                this.removeKey(meta, "File Modified Date");
                this.save(meta, output[i]);
            }
            catch (Exception e) {
                ImageMetaDataHelperTest.fail((String)("Failed to extract meta-data from: " + input[i]));
            }
            this.m_TestHelper.deleteFileFromTmp(input[i]);
        }
        String diff = reg.compare((File[])regFiles);
        if (diff != null) {
            ImageMetaDataHelperTest.fail((String)diff);
        }
    }

    public static Test suite() {
        return new TestSuite(ImageMetaDataHelperTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        ImageMetaDataHelperTest.runTest((Test)ImageMetaDataHelperTest.suite());
    }
}

