/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.VariableName;
import adams.core.base.BaseText;
import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.data.conversion.Conversion;
import adams.data.conversion.StringToString;
import adams.data.io.input.AbstractReportReader;
import adams.data.io.input.DefaultSimpleReportReader;
import adams.data.objectoverlap.AreaRatio;
import adams.data.objectoverlap.IntersectOverUnionRatio;
import adams.data.objectoverlap.ObjectOverlap;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.control.StorageName;
import adams.flow.control.Trigger;
import adams.flow.control.flowrestart.AbstractFlowRestartManager;
import adams.flow.control.flowrestart.NullManager;
import adams.flow.core.AbstractActor;
import adams.flow.core.Actor;
import adams.flow.execution.FlowExecutionListener;
import adams.flow.execution.NullListener;
import adams.flow.sink.DumpFile;
import adams.flow.source.Start;
import adams.flow.source.Variable;
import adams.flow.standalone.DeleteStorageValue;
import adams.flow.standalone.SetVariable;
import adams.flow.transformer.DetermineOverlappingObjects;
import adams.flow.transformer.ReportFileReader;
import adams.flow.transformer.SetStorageValue;
import adams.test.TmpFile;
import java.io.File;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;

public class DetermineOverlappingObjectsTest
extends AbstractFlowTest {
    public DetermineOverlappingObjectsTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("image_object_overlap_iou_gt.report");
        this.m_TestHelper.copyResourceToTmp("image_object_overlap_iou_pred.report");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("image_object_overlap_iou_gt.report");
        this.m_TestHelper.deleteFileFromTmp("image_object_overlap_iou_pred.report");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public void testRegression() {
        this.performRegressionTest((File[])new TmpFile[]{new TmpFile("dumpfile.txt")});
    }

    public static Test suite() {
        return new TestSuite(DetermineOverlappingObjectsTest.class);
    }

    public AbstractActor getActor() {
        Flow flow = new Flow();
        try {
            ArrayList<Object> actors = new ArrayList<Object>();
            SetVariable setvariable = new SetVariable();
            AbstractArgumentOption argOption = (AbstractArgumentOption)setvariable.getOptionManager().findByProperty("variableName");
            setvariable.setVariableName((VariableName)argOption.valueOf("gt_file"));
            argOption = (AbstractArgumentOption)setvariable.getOptionManager().findByProperty("variableValue");
            setvariable.setVariableValue((BaseText)argOption.valueOf("${TMP}/image_object_overlap_iou_gt.report"));
            actors.add(setvariable);
            SetVariable setvariable2 = new SetVariable();
            argOption = (AbstractArgumentOption)setvariable2.getOptionManager().findByProperty("name");
            setvariable2.setName((String)argOption.valueOf("SetVariable (2)"));
            argOption = (AbstractArgumentOption)setvariable2.getOptionManager().findByProperty("variableName");
            setvariable2.setVariableName((VariableName)argOption.valueOf("pred_file"));
            argOption = (AbstractArgumentOption)setvariable2.getOptionManager().findByProperty("variableValue");
            setvariable2.setVariableValue((BaseText)argOption.valueOf("${TMP}/image_object_overlap_iou_pred.report"));
            actors.add(setvariable2);
            Start start = new Start();
            actors.add(start);
            Trigger trigger = new Trigger();
            argOption = (AbstractArgumentOption)trigger.getOptionManager().findByProperty("name");
            trigger.setName((String)argOption.valueOf("Load Pred"));
            ArrayList<Object> actors2 = new ArrayList<Object>();
            Variable variable = new Variable();
            argOption = (AbstractArgumentOption)variable.getOptionManager().findByProperty("variableName");
            variable.setVariableName((VariableName)argOption.valueOf("pred_file"));
            StringToString stringtostring = new StringToString();
            variable.setConversion((Conversion)stringtostring);
            actors2.add(variable);
            ReportFileReader reportfilereader = new ReportFileReader();
            DefaultSimpleReportReader defaultsimplereportreader = new DefaultSimpleReportReader();
            reportfilereader.setReader((AbstractReportReader)defaultsimplereportreader);
            actors2.add(reportfilereader);
            SetStorageValue setstoragevalue = new SetStorageValue();
            argOption = (AbstractArgumentOption)setstoragevalue.getOptionManager().findByProperty("storageName");
            setstoragevalue.setStorageName((StorageName)argOption.valueOf("pred"));
            actors2.add(setstoragevalue);
            trigger.setActors(actors2.toArray(new Actor[0]));
            actors.add(trigger);
            Trigger triggerCompareIOU = new Trigger();
            argOption = (AbstractArgumentOption)triggerCompareIOU.getOptionManager().findByProperty("name");
            triggerCompareIOU.setName((String)argOption.valueOf("CompareIOU"));
            ArrayList<Object> actorsIOU = new ArrayList<Object>();
            Variable variable2 = new Variable();
            argOption = (AbstractArgumentOption)variable2.getOptionManager().findByProperty("variableName");
            variable2.setVariableName((VariableName)argOption.valueOf("gt_file"));
            StringToString stringtostring2 = new StringToString();
            variable2.setConversion((Conversion)stringtostring2);
            actorsIOU.add(variable2);
            ReportFileReader reportfilereader2 = new ReportFileReader();
            DefaultSimpleReportReader defaultsimplereportreader2 = new DefaultSimpleReportReader();
            reportfilereader2.setReader((AbstractReportReader)defaultsimplereportreader2);
            actorsIOU.add(reportfilereader2);
            IntersectOverUnionRatio iou = new IntersectOverUnionRatio();
            iou.setMinIntersectOverUnionRatio(0.5);
            iou.setLabelKey("type");
            iou.setUseOtherObject(true);
            iou.setAdditionalObject(true);
            DetermineOverlappingObjects overlappingIOU = new DetermineOverlappingObjects();
            overlappingIOU.setStorageName(new StorageName("pred"));
            overlappingIOU.setAlgorithm((ObjectOverlap)iou);
            actorsIOU.add(overlappingIOU);
            DumpFile dumpfile = new DumpFile();
            argOption = (AbstractArgumentOption)dumpfile.getOptionManager().findByProperty("outputFile");
            dumpfile.setOutputFile((PlaceholderFile)argOption.valueOf("${TMP}/dumpfile.txt"));
            actorsIOU.add(dumpfile);
            triggerCompareIOU.setActors(actorsIOU.toArray(new Actor[0]));
            actors.add(triggerCompareIOU);
            Trigger triggerArea = new Trigger();
            argOption = (AbstractArgumentOption)triggerArea.getOptionManager().findByProperty("name");
            triggerArea.setName((String)argOption.valueOf("CompareArea"));
            ArrayList<Object> actorsArea = new ArrayList<Object>();
            variable2 = new Variable();
            argOption = (AbstractArgumentOption)variable2.getOptionManager().findByProperty("variableName");
            variable2.setVariableName((VariableName)argOption.valueOf("gt_file"));
            stringtostring2 = new StringToString();
            variable2.setConversion((Conversion)stringtostring2);
            actorsArea.add(variable2);
            reportfilereader2 = new ReportFileReader();
            defaultsimplereportreader2 = new DefaultSimpleReportReader();
            reportfilereader2.setReader((AbstractReportReader)defaultsimplereportreader2);
            actorsArea.add(reportfilereader2);
            AreaRatio area = new AreaRatio();
            area.setMinOverlapRatio(0.5);
            area.setLabelKey("type");
            area.setUseOtherObject(true);
            area.setAdditionalObject(true);
            area.setAverageRatio(true);
            DetermineOverlappingObjects overlappingArea = new DetermineOverlappingObjects();
            overlappingArea.setStorageName(new StorageName("pred"));
            overlappingArea.setAlgorithm((ObjectOverlap)area);
            actorsArea.add(overlappingArea);
            dumpfile = new DumpFile();
            argOption = (AbstractArgumentOption)dumpfile.getOptionManager().findByProperty("outputFile");
            dumpfile.setOutputFile((PlaceholderFile)argOption.valueOf("${TMP}/dumpfile.txt"));
            dumpfile.setAppend(true);
            actorsArea.add(dumpfile);
            triggerArea.setActors(actorsArea.toArray(new Actor[0]));
            actors.add(triggerArea);
            Trigger trigger3 = new Trigger();
            argOption = (AbstractArgumentOption)trigger3.getOptionManager().findByProperty("name");
            trigger3.setName((String)argOption.valueOf("Clean"));
            ArrayList<DeleteStorageValue> actors4 = new ArrayList<DeleteStorageValue>();
            DeleteStorageValue deletestoragevalue = new DeleteStorageValue();
            argOption = (AbstractArgumentOption)deletestoragevalue.getOptionManager().findByProperty("storageName");
            deletestoragevalue.setStorageName((StorageName)argOption.valueOf("pred"));
            actors4.add(deletestoragevalue);
            trigger3.setActors(actors4.toArray(new Actor[0]));
            actors.add(trigger3);
            flow.setActors(actors.toArray(new Actor[0]));
            NullListener nulllistener = new NullListener();
            flow.setFlowExecutionListener((FlowExecutionListener)nulllistener);
            NullManager nullmanager = new NullManager();
            flow.setFlowRestartManager((AbstractFlowRestartManager)nullmanager);
            System.out.println(flow.toCommandLine());
        }
        catch (Exception e) {
            DetermineOverlappingObjectsTest.fail((String)("Failed to set up actor: " + e));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        DetermineOverlappingObjectsTest.runTest((Test)DetermineOverlappingObjectsTest.suite());
    }
}

