/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.AbstractFilenameGenerator;
import adams.core.io.FixedFilenameGenerator;
import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.data.io.input.AbstractImageReader;
import adams.data.io.input.AbstractReportReader;
import adams.data.io.input.DefaultSimpleReportReader;
import adams.data.io.input.JAIImageReader;
import adams.data.io.output.AbstractReportWriter;
import adams.data.io.output.DefaultSimpleReportWriter;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.Actor;
import adams.flow.source.FileSupplier;
import adams.flow.transformer.ImageFileReader;
import adams.flow.transformer.ReportFileWriter;
import adams.flow.transformer.SetReportFromFile;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class SetReportFromFileTest
extends AbstractFlowTest {
    public SetReportFromFileTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("adams_logo.png");
        this.m_TestHelper.copyResourceToTmp("test.report");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("adams_logo.png");
        this.m_TestHelper.deleteFileFromTmp("test.report");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    protected int[] getRegressionIgnoredLineIndices() {
        return new int[]{0, 1};
    }

    public void testRegression() {
        this.performRegressionTest((File[])new TmpFile[]{new TmpFile("dumpfile.txt")});
    }

    public static Test suite() {
        return new TestSuite(SetReportFromFileTest.class);
    }

    public Actor getActor() {
        Flow flow = new Flow();
        try {
            AbstractArgumentOption argOption = (AbstractArgumentOption)flow.getOptionManager().findByProperty("actors");
            Actor[] tmp1 = new Actor[4];
            FileSupplier tmp2 = new FileSupplier();
            argOption = (AbstractArgumentOption)tmp2.getOptionManager().findByProperty("files");
            tmp2.setFiles(new PlaceholderFile[]{(PlaceholderFile)argOption.valueOf("${TMP}/adams_logo.png")});
            tmp1[0] = tmp2;
            ImageFileReader tmp4 = new ImageFileReader();
            tmp4.setReader((AbstractImageReader)new JAIImageReader());
            tmp1[1] = tmp4;
            SetReportFromFile tmp5 = new SetReportFromFile();
            argOption = (AbstractArgumentOption)tmp5.getOptionManager().findByProperty("reportFile");
            tmp5.setReportFile((PlaceholderFile)argOption.valueOf("${TMP}/test.report"));
            argOption = (AbstractArgumentOption)tmp5.getOptionManager().findByProperty("reader");
            DefaultSimpleReportReader tmp8 = new DefaultSimpleReportReader();
            tmp5.setReader((AbstractReportReader)tmp8);
            tmp1[2] = tmp5;
            ReportFileWriter tmp9 = new ReportFileWriter();
            argOption = (AbstractArgumentOption)tmp9.getOptionManager().findByProperty("writer");
            DefaultSimpleReportWriter tmp11 = new DefaultSimpleReportWriter();
            tmp9.setWriter((AbstractReportWriter)tmp11);
            argOption = (AbstractArgumentOption)tmp9.getOptionManager().findByProperty("outputDir");
            tmp9.setOutputDir((PlaceholderDirectory)argOption.valueOf("${TMP}"));
            argOption = (AbstractArgumentOption)tmp9.getOptionManager().findByProperty("filenameGenerator");
            FixedFilenameGenerator tmp14 = new FixedFilenameGenerator();
            argOption = (AbstractArgumentOption)tmp14.getOptionManager().findByProperty("name");
            tmp14.setName((String)argOption.valueOf("dumpfile.txt"));
            tmp9.setFilenameGenerator((AbstractFilenameGenerator)tmp14);
            tmp1[3] = tmp9;
            flow.setActors(tmp1);
        }
        catch (Exception e) {
            SetReportFromFileTest.fail((String)("Failed to set up actor: " + e));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        SetReportFromFileTest.runTest((Test)SetReportFromFileTest.suite());
    }
}

