/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io.fileuse;

import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.io.fileuse.AbstractFileUseCheck;
import java.io.Closeable;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.logging.Level;

public class JpegIsComplete
extends AbstractFileUseCheck {
    private static final long serialVersionUID = -3766862011655514895L;

    public String globalInfo() {
        return "Checks whether the JPEG file ends with bytes FFD9 (EOF for JPEGs).\nSee also:\nhttp://en.wikipedia.org/wiki/JPEG#Syntax_and_structure";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInUse(File file) {
        boolean result;
        RandomAccessFile raf;
        block7: {
            raf = null;
            try {
                byte[] buffer = new byte[2];
                raf = new RandomAccessFile(file.getAbsolutePath(), "r");
                if (file.length() > 2L) {
                    raf.seek(file.length() - 2L);
                    raf.read(buffer, 0, 2);
                    boolean bl = result = buffer[0] != -1 || buffer[1] != -39;
                    if (this.isLoggingEnabled()) {
                        this.getLogger().info("Last two bytes: " + Utils.toHex((byte)buffer[0]) + Utils.toHex((byte)buffer[1]) + " -> " + result);
                    }
                    break block7;
                }
                result = true;
            }
            catch (Exception e) {
                try {
                    if (this.isLoggingEnabled()) {
                        this.getLogger().log(Level.SEVERE, "Failed to extract bytes from: " + file, (Throwable)e);
                    }
                    result = true;
                }
                catch (Throwable throwable) {
                    FileUtils.closeQuietly(raf);
                    throw throwable;
                }
                FileUtils.closeQuietly((Closeable)raf);
            }
        }
        FileUtils.closeQuietly((Closeable)raf);
        return result;
    }
}

