/*
 * Decompiled with CFR 0.152.
 */
package adams.data.barcode.encode;

import adams.data.barcode.encode.AbstractBarcodeEncoder;
import adams.data.image.BufferedImageContainer;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.image.BufferedImage;
import java.util.HashMap;

public class QRCode
extends AbstractBarcodeEncoder {
    private static final long serialVersionUID = -108663694502130066L;
    protected ErrorCorrectionLevel m_ErrorCorrectionLevel;
    protected String m_Text;

    public String globalInfo() {
        return "Draws a QR code at a specified location and size.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("text", "text", (Object)"foobar");
        this.m_OptionManager.add("errorCorrectionLevel", "errorCorrectionLevel", (Object)ErrorCorrectionLevel.L);
    }

    public String getText() {
        return this.m_Text;
    }

    public void setText(String value) {
        if (value != null && !value.isEmpty()) {
            this.m_Text = value;
            this.reset();
        } else {
            this.getLogger().severe("Text must not be null or empty.");
        }
    }

    public String textTipText() {
        return "Text to be encoded.";
    }

    public void setErrorCorrectionLevel(ErrorCorrectionLevel value) {
        this.m_ErrorCorrectionLevel = value;
        this.reset();
    }

    public ErrorCorrectionLevel getErrorCorrectionLevel() {
        return this.m_ErrorCorrectionLevel;
    }

    public String errorCorrectionLevelTipText() {
        return "Error correction level.";
    }

    @Override
    protected String doDraw(BufferedImageContainer image) {
        String result = null;
        try {
            QRCodeWriter writer = new QRCodeWriter();
            HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
            hints.put(EncodeHintType.ERROR_CORRECTION, this.m_ErrorCorrectionLevel);
            hints.put(EncodeHintType.MARGIN, this.m_Margin);
            BitMatrix matrix = writer.encode(this.m_Text, BarcodeFormat.QR_CODE, this.m_Width, this.m_Height, hints);
            for (int y = this.m_Y; y < this.m_Height; ++y) {
                for (int x = this.m_X; x < this.m_Width; ++x) {
                    ((BufferedImage)image.getImage()).setRGB(x, y, matrix.get(x, y) ? 0 : 0xFFFFFF);
                }
            }
        }
        catch (WriterException e) {
            result = e.getMessage();
        }
        return result;
    }
}

