/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image;

import adams.core.option.AbstractOptionHandler;
import adams.data.image.AbstractImageContainer;

public abstract class AbstractMultiImageOperation<T extends AbstractImageContainer>
extends AbstractOptionHandler {
    private static final long serialVersionUID = 1185449853784824033L;

    public abstract int minNumImagesRequired();

    public abstract int maxNumImagesRequired();

    protected boolean checkSameDimensions(T image1, T image2) {
        return image1.getWidth() == image2.getWidth() && image1.getHeight() == image2.getHeight();
    }

    protected String checkSameDimensions(T[] images) {
        for (int i = 1; i < images.length; ++i) {
            if (this.checkSameDimensions(images[0], images[i])) continue;
            return "All images need to have the same dimensions: " + images[0].getWidth() + "x" + images[0].getHeight() + " (#1) != " + images[i].getWidth() + "x" + images[i].getHeight() + "(#" + (i + 1) + ")";
        }
        return null;
    }

    protected void check(T[] images) {
        if (images == null || images.length == 0) {
            throw new IllegalStateException("No images provided!");
        }
        if (this.minNumImagesRequired() > 0 && images.length < this.minNumImagesRequired()) {
            throw new IllegalStateException("Not enough images supplied (min > supplied): " + this.minNumImagesRequired() + " > " + images.length);
        }
        if (this.maxNumImagesRequired() > 0 && images.length > this.maxNumImagesRequired()) {
            throw new IllegalStateException("Too many images supplied (max < supplied): " + this.maxNumImagesRequired() + " < " + images.length);
        }
    }

    protected abstract T[] doProcess(T[] var1);

    public T[] process(T[] images) {
        this.check((AbstractImageContainer[])images);
        return this.doProcess((AbstractImageContainer[])images);
    }
}

