/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image;

import adams.core.logging.Logger;
import adams.data.statistics.StatUtils;
import java.awt.image.BufferedImage;

public class XScreenMaskHelper {
    public static int[][] generateMask(BufferedImage image, Color color) {
        float[][] mask = new float[image.getHeight()][image.getWidth()];
        float min = Float.POSITIVE_INFINITY;
        float max = Float.NEGATIVE_INFINITY;
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int value;
                int rgb = image.getRGB(x, y);
                int r = rgb >> 16 & 0xFF;
                int g = rgb >> 8 & 0xFF;
                int b = rgb & 0xFF;
                switch (color) {
                    case RED: {
                        value = r * (r - b) * (r - g);
                        break;
                    }
                    case GREEN: {
                        value = g * (g - r) * (g - b);
                        break;
                    }
                    case BLUE: {
                        value = b * (b - r) * (b - g);
                        break;
                    }
                    case YELLOW: {
                        value = (r - b) * (g - b);
                        break;
                    }
                    case LUMINANCE: {
                        value = (int)Math.round(0.2126 * (double)r + 0.7152 * (double)g + 0.0722 * (double)b);
                        break;
                    }
                    case NO_MASK: {
                        value = rgb;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Color not implemented: " + color.name());
                    }
                }
                mask[y][x] = value;
                if ((float)value > max) {
                    max = value;
                }
                if (!((float)value < min)) continue;
                min = value;
            }
        }
        int[][] normalized = new int[image.getHeight()][image.getWidth()];
        float ratio = 255.0f / (max - min);
        for (int y = 0; y < mask.length; ++y) {
            for (int x = 0; x < mask[0].length; ++x) {
                normalized[y][x] = Math.round((mask[y][x] - min) * ratio);
            }
        }
        return normalized;
    }

    public static BufferedImage applyMask(BufferedImage image, int[][] mask, int threshold, boolean down, Logger log) {
        BufferedImage output = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        if (image.getWidth() != mask[0].length || image.getHeight() != mask.length) {
            throw new IllegalStateException("Image and mask dimensions mismatch!");
        }
        if (threshold < 0) {
            threshold = XScreenMaskHelper.determineThreshold(mask, log);
        }
        for (int y = 0; y < mask.length; ++y) {
            for (int x = 0; x < mask[0].length; ++x) {
                int rgb = image.getRGB(x, y);
                if (down) {
                    output.setRGB(x, y, mask[y][x] <= threshold ? rgb : rgb & 0xFFFFFF);
                    continue;
                }
                output.setRGB(x, y, mask[y][x] >= threshold ? rgb : rgb & 0xFFFFFF);
            }
        }
        return output;
    }

    public static void binarizeMask(int[][] mask, int threshold, boolean down, Logger log) {
        if (threshold < 0) {
            threshold = XScreenMaskHelper.determineThreshold(mask, log);
        }
        for (int y = 0; y < mask.length; ++y) {
            for (int x = 0; x < mask[0].length; ++x) {
                mask[y][x] = down ? (mask[y][x] <= threshold ? 1 : 0) : (mask[y][x] >= threshold ? 1 : 0);
            }
        }
    }

    protected static int findThreshold(int[] histogram, int limit) {
        int threshold = histogram.length / 2;
        if (histogram[threshold] <= limit) {
            while (threshold < 256 && histogram[threshold] <= limit) {
                ++threshold;
            }
        } else {
            while (threshold > 0 && histogram[threshold] > limit) {
                --threshold;
            }
        }
        return threshold;
    }

    public static int determineThreshold(int[][] mask, Logger log) {
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        int[] histogram = new int[256];
        for (int y = 0; y < mask.length; ++y) {
            for (int x = 0; x < mask[0].length; ++x) {
                int value;
                int n = mask[y][x];
                histogram[n] = histogram[n] + 1;
                if (value > max) {
                    max = value;
                }
                if (value >= min) continue;
                min = value;
            }
        }
        float ratio = 255.0f / (float)(max - min);
        for (int i = 0; i < histogram.length; ++i) {
            histogram[i] = Math.round((float)(histogram[i] - min) * ratio);
        }
        int threshold = XScreenMaskHelper.findThreshold(histogram, 1);
        if (threshold < 10 || threshold > 245) {
            int limit = (int)(StatUtils.median((int[])histogram) / 4.0);
            if (log != null) {
                log.warning("Skewed threshold index (" + threshold + ") found, retrying with new limit: " + limit);
            }
            threshold = XScreenMaskHelper.findThreshold(histogram, limit);
        }
        if (log != null) {
            log.info("Threshold index: " + threshold);
        }
        return threshold;
    }

    public static enum Color {
        RED,
        GREEN,
        BLUE,
        YELLOW,
        LUMINANCE,
        NO_MASK;

    }
}

