/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.features;

import adams.data.image.BufferedImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.image.features.AbstractCountColor;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public class CountColor
extends AbstractCountColor {
    private static final long serialVersionUID = -8349656592325229512L;

    public String globalInfo() {
        return "Counts the occurrences of a specific color (alpha channel gets ignored).";
    }

    @Override
    public List<Object>[] generateRows(BufferedImageContainer img) {
        BufferedImage image = BufferedImageHelper.convert((BufferedImage)((BufferedImage)img.getImage()), (int)6);
        int count = 0;
        int color = this.m_Color.getRGB() & 0xFFFFFF;
        int[] pixels = BufferedImageHelper.getPixels((BufferedImage)image);
        for (int i = 0; i < pixels.length; ++i) {
            if ((pixels[i] & 0xFFFFFF) != color) continue;
            ++count;
        }
        List[] result = new List[]{new ArrayList()};
        if (this.m_UsePercentage) {
            result[0].add((double)count / (double)pixels.length);
        } else {
            result[0].add(count);
        }
        return result;
    }
}

