/*
 * Decompiled with CFR 0.152.
 */
package adams.data.jai.features;

import adams.data.featureconverter.HeaderDefinition;
import adams.data.image.BufferedImageContainer;
import adams.data.image.features.AbstractBufferedImageFeatureGenerator;
import adams.data.report.DataType;
import adams.data.statistics.StatUtils;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.DFTDescriptor;

public class DFT
extends AbstractBufferedImageFeatureGenerator {
    private static final long serialVersionUID = 3993399058139605286L;
    protected OutputType m_OutputType;

    public String globalInfo() {
        return "Performs discrete fourier transform (DFT).";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("output-type", "outputType", (Object)OutputType.BOTH);
    }

    public void setOutputType(OutputType value) {
        this.m_OutputType = value;
        this.reset();
    }

    public OutputType getOutputType() {
        return this.m_OutputType;
    }

    public String outputTypeTipText() {
        return "The type of output to generate.";
    }

    @Override
    public HeaderDefinition createHeader(BufferedImageContainer img) {
        HeaderDefinition result = new HeaderDefinition();
        double[] values = this.performDFT(img);
        switch (this.m_OutputType) {
            case BOTH: {
                for (int i = 0; i < values.length; ++i) {
                    if (i % 2 == 0) {
                        result.add("real_" + (i / 2 + 1), DataType.NUMERIC);
                        continue;
                    }
                    result.add("imag_" + (i / 2 + 1), DataType.NUMERIC);
                }
                break;
            }
            case REAL: {
                for (int i = 0; i < values.length; ++i) {
                    result.add("real_" + (i + 1), DataType.NUMERIC);
                }
                break;
            }
            case IMAGINARY: {
                for (int i = 0; i < values.length; ++i) {
                    result.add("imag_" + (i + 1), DataType.NUMERIC);
                }
                break;
            }
        }
        return result;
    }

    protected double[] performDFT(BufferedImageContainer img) {
        double[] values;
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(PlanarImage.wrapRenderedImage((RenderedImage)((RenderedImage)img.getImage())));
        pb.add(DFTDescriptor.SCALING_NONE);
        pb.add(DFTDescriptor.REAL_TO_COMPLEX);
        RenderedOp dft = JAI.create((String)"dft", (ParameterBlock)pb, null);
        Raster dftData = dft.getData();
        double[] real = dftData.getSamples(0, 0, dft.getWidth(), dft.getHeight(), 0, (double[])null);
        double[] imag = dftData.getSamples(0, 0, dft.getWidth(), dft.getHeight(), 1, (double[])null);
        switch (this.m_OutputType) {
            case BOTH: {
                values = new double[real.length + imag.length];
                for (int i = 0; i < real.length; ++i) {
                    values[i * 2 + 0] = real[i];
                    values[i * 2 + 1] = imag[i];
                }
                break;
            }
            case REAL: {
                values = new double[real.length];
                for (int i = 0; i < real.length; ++i) {
                    values[i] = real[i];
                }
                break;
            }
            case IMAGINARY: {
                values = new double[imag.length];
                for (int i = 0; i < imag.length; ++i) {
                    values[i] = imag[i];
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled output type: " + (Object)((Object)this.m_OutputType));
            }
        }
        return values;
    }

    @Override
    public List<Object>[] generateRows(BufferedImageContainer img) {
        double[] values = this.performDFT(img);
        List[] result = new List[]{new ArrayList()};
        result[0].addAll(Arrays.asList(StatUtils.toNumberArray((double[])values)));
        return result;
    }

    public static enum OutputType {
        REAL,
        IMAGINARY,
        BOTH;

    }
}

