/*
 * Decompiled with CFR 0.152.
 */
package adams.data.jai.transformer;

import adams.data.image.BufferedImageContainer;
import adams.data.jai.transformer.AbstractJAITransformer;
import java.awt.image.RenderedImage;
import javax.media.jai.KernelJAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.DilateDescriptor;

public class Dilate
extends AbstractJAITransformer {
    private static final long serialVersionUID = 2959486760492196174L;
    protected float[] m_Kernel;
    protected int m_KernelHeight;
    protected int m_KernelWidth;

    public String globalInfo() {
        return "Performs dilation.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("kernel", "kernel", (Object)"0 1 0 1 1 1 0 1 0");
        this.m_OptionManager.add("kernel-width", "kernelWidth", (Object)3, (Number)1, null);
        this.m_OptionManager.add("kernel-height", "kernelHeight", (Object)3, (Number)1, null);
    }

    public void setKernel(String value) {
        if (value.trim().isEmpty()) {
            this.m_Kernel = new float[0];
        } else {
            String[] values = value.split(" ");
            this.m_Kernel = new float[values.length];
            for (int i = 0; i < values.length; ++i) {
                this.m_Kernel[i] = Float.parseFloat(values[i]);
            }
        }
        this.reset();
    }

    public String getKernel() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.m_Kernel.length; ++i) {
            if (i > 0) {
                result.append(" ");
            }
            result.append(Float.toString(this.m_Kernel[i]));
        }
        return result.toString();
    }

    public String kernelTipText() {
        return "The kernel to use; blank-separated floats; row-wise.";
    }

    public void setKernelWidth(int value) {
        if (this.getOptionManager().isValid("kernelWidth", (Number)value)) {
            this.m_KernelWidth = value;
            this.reset();
        }
    }

    public int getKernelWidth() {
        return this.m_KernelWidth;
    }

    public String kernelWidthTipText() {
        return "The width of the kernel.";
    }

    public void setKernelHeight(int value) {
        if (this.getOptionManager().isValid("kernelHeight", (Number)value)) {
            this.m_KernelHeight = value;
            this.reset();
        }
    }

    public int getKernelHeight() {
        return this.m_KernelHeight;
    }

    public String kernelHeightTipText() {
        return "The height of the kernel.";
    }

    protected BufferedImageContainer[] doTransform(BufferedImageContainer img) {
        BufferedImageContainer[] result = new BufferedImageContainer[1];
        KernelJAI kernel = new KernelJAI(this.m_KernelWidth, this.m_KernelHeight, this.m_Kernel);
        RenderedOp op = DilateDescriptor.create((RenderedImage)((RenderedImage)img.getImage()), (KernelJAI)kernel, null);
        result[0] = (BufferedImageContainer)img.getHeader();
        result[0].setImage((Object)op.getAsBufferedImage());
        return result;
    }
}

