/*
 * Decompiled with CFR 0.152.
 */
package adams.data.objectfinder;

import adams.data.objectfinder.AbstractMetaObjectFinder;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.set.hash.TIntHashSet;
import java.util.logging.Level;

public class Invert
extends AbstractMetaObjectFinder {
    private static final long serialVersionUID = -8034475536001525696L;

    public String globalInfo() {
        return "Inverts the indices of the base object finder.";
    }

    @Override
    protected int[] doFind(LocatedObjects objects) {
        TIntArrayList result = new TIntArrayList();
        TIntHashSet base = new TIntHashSet(this.m_ObjectFinder.find(objects));
        for (LocatedObject obj : objects) {
            if (obj.getMetaData() != null) {
                try {
                    if (obj.getMetaData().containsKey("index")) {
                        int index = obj.getIndex();
                        if (base.contains(index)) continue;
                        result.add(index);
                        continue;
                    }
                    if (!this.isLoggingEnabled()) continue;
                    this.getLogger().warning("Object has no index in meta-data: " + obj);
                }
                catch (Exception e) {
                    this.getLogger().log(Level.SEVERE, "Failed to parse index: " + obj.getMetaData().get("index"), (Throwable)e);
                }
                continue;
            }
            if (!this.isLoggingEnabled()) continue;
            this.getLogger().warning("Object has no meta-data: " + obj);
        }
        return result.toArray();
    }
}

