/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.image.AbstractImageContainer;
import adams.data.report.Report;
import adams.flow.control.StorageName;
import adams.flow.control.StorageUser;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractInteractiveTransformerDialog;
import adams.flow.transformer.compareobjectlocations.AbstractComparison;
import adams.flow.transformer.compareobjectlocations.AbstractComparisonPanel;
import adams.flow.transformer.compareobjectlocations.SideBySide;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import adams.gui.core.BaseButton;
import adams.gui.core.BaseDialog;
import adams.gui.core.BasePanel;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.JPanel;

public class CompareObjectLocations
extends AbstractInteractiveTransformerDialog
implements StorageUser {
    private static final long serialVersionUID = 2191236912048968711L;
    protected StorageName m_AnnotationsStorageName;
    protected String m_AnnotationsPrefix;
    protected String m_AnnotationsLabelSuffix;
    protected StorageName m_PredictionsStorageName;
    protected String m_PredictionsPrefix;
    protected String m_PredictionsLabelSuffix;
    protected AbstractComparison m_Comparison;
    protected AbstractComparisonPanel m_ComparisonPanel;
    protected boolean m_Accepted;

    public String globalInfo() {
        return "Visualizes object locations (annotations and predicted) for the incoming image side-by-side.\nOnly forwards the image container when accepted.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("annotations-storage-name", "annotationsStorageName", (Object)new StorageName());
        this.m_OptionManager.add("annotations-prefix", "annotationsPrefix", (Object)"Object.");
        this.m_OptionManager.add("annotations-label-suffix", "annotationsLabelSuffix", (Object)"type");
        this.m_OptionManager.add("predictions-storage-name", "predictionsStorageName", (Object)new StorageName());
        this.m_OptionManager.add("predictions-prefix", "predictionsPrefix", (Object)"Object.");
        this.m_OptionManager.add("predictions-label-suffix", "predictionsLabelSuffix", (Object)"type");
        this.m_OptionManager.add("comparison", "comparison", (Object)new SideBySide());
    }

    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"annotationsStoragName", (Object)this.m_AnnotationsStorageName, (String)", annotations: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"predictionsStorageName", (Object)this.m_PredictionsStorageName, (String)", predictions: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"comparison", (Object)((Object)this.m_Comparison), (String)", comparison: ");
        return result;
    }

    public void setAnnotationsStorageName(StorageName value) {
        this.m_AnnotationsStorageName = value;
        this.reset();
    }

    public StorageName getAnnotationsStorageName() {
        return this.m_AnnotationsStorageName;
    }

    public String annotationsStorageNameTipText() {
        return "The name of the storage item containing the annotations (ground truth).";
    }

    public void setAnnotationsPrefix(String value) {
        this.m_AnnotationsPrefix = value;
        this.reset();
    }

    public String getAnnotationsPrefix() {
        return this.m_AnnotationsPrefix;
    }

    public String annotationsPrefixTipText() {
        return "The object prefix that the annotations use.";
    }

    public void setAnnotationsLabelSuffix(String value) {
        this.m_AnnotationsLabelSuffix = value;
        this.reset();
    }

    public String getAnnotationsLabelSuffix() {
        return this.m_AnnotationsLabelSuffix;
    }

    public String annotationsLabelSuffixTipText() {
        return "The report suffix that the annotations use for storing the label.";
    }

    public void setPredictionsStorageName(StorageName value) {
        this.m_PredictionsStorageName = value;
        this.reset();
    }

    public StorageName getPredictionsStorageName() {
        return this.m_PredictionsStorageName;
    }

    public String predictionsStorageNameTipText() {
        return "The name of the storage item containing the predictions.";
    }

    public void setPredictionsPrefix(String value) {
        this.m_PredictionsPrefix = value;
        this.reset();
    }

    public String getPredictionsPrefix() {
        return this.m_PredictionsPrefix;
    }

    public String predictionsPrefixTipText() {
        return "The object prefix that the predictions use.";
    }

    public void setPredictionsLabelSuffix(String value) {
        this.m_PredictionsLabelSuffix = value;
        this.reset();
    }

    public String getPredictionsLabelSuffix() {
        return this.m_PredictionsLabelSuffix;
    }

    public String predictionsLabelSuffixTipText() {
        return "The report suffix that the predictions use for storing the label.";
    }

    public void setComparison(AbstractComparison value) {
        this.m_Comparison = value;
        this.reset();
    }

    public AbstractComparison getComparison() {
        return this.m_Comparison;
    }

    public String comparisonTipText() {
        return "The comparison view to use.";
    }

    public boolean isUsingStorage() {
        return !this.getSkip();
    }

    public Class[] accepts() {
        return new Class[]{AbstractImageContainer.class};
    }

    public Class[] generates() {
        return new Class[]{AbstractImageContainer.class};
    }

    public void clearPanel() {
        if (this.m_ComparisonPanel != null) {
            this.m_ComparisonPanel.clearPanel();
        }
    }

    protected BasePanel newPanel() {
        this.m_ComparisonPanel = this.m_Comparison.generate(this);
        return this.m_ComparisonPanel;
    }

    protected void postCreateDialog(BaseDialog dialog, BasePanel panel) {
        JPanel panelButtons = new JPanel(new FlowLayout(2));
        dialog.getContentPane().add((Component)panelButtons, "South");
        BaseButton buttonOK = new BaseButton("OK");
        buttonOK.addActionListener(e -> {
            this.m_Accepted = true;
            dialog.setVisible(false);
        });
        panelButtons.add((Component)buttonOK);
        BaseButton buttonCancel = new BaseButton("Cancel");
        buttonCancel.addActionListener(e -> {
            this.m_Accepted = false;
            dialog.setVisible(false);
        });
        panelButtons.add((Component)buttonCancel);
    }

    protected boolean display(Token token) {
        if (!this.getStorageHandler().getStorage().has(this.m_AnnotationsStorageName)) {
            this.getLogger().severe("Annotations not available from storage: " + this.m_AnnotationsStorageName);
            return false;
        }
        Report annRep = (Report)this.getStorageHandler().getStorage().get(this.m_AnnotationsStorageName);
        LocatedObjects annObj = LocatedObjects.fromReport(annRep, this.m_AnnotationsPrefix);
        if (!this.getStorageHandler().getStorage().has(this.m_PredictionsStorageName)) {
            this.getLogger().severe("Predictions not available from storage: " + this.m_PredictionsStorageName);
            return false;
        }
        Report predRep = (Report)this.getStorageHandler().getStorage().get(this.m_PredictionsStorageName);
        LocatedObjects predObj = LocatedObjects.fromReport(predRep, this.m_PredictionsPrefix);
        HashSet<String> labels = new HashSet<String>();
        for (LocatedObject obj : annObj) {
            if (!obj.getMetaData().containsKey(this.m_AnnotationsLabelSuffix)) continue;
            labels.add("" + obj.getMetaData().get(this.m_AnnotationsLabelSuffix));
        }
        for (LocatedObject obj : predObj) {
            if (!obj.getMetaData().containsKey(this.m_PredictionsLabelSuffix)) continue;
            labels.add("" + obj.getMetaData().get(this.m_PredictionsLabelSuffix));
        }
        ArrayList<String> labelsSorted = new ArrayList<String>(labels);
        Collections.sort(labelsSorted);
        this.m_ComparisonPanel.display((AbstractImageContainer)token.getPayload(AbstractImageContainer.class), labelsSorted, annRep, annObj, predRep, predObj);
        return true;
    }

    public boolean doInteract() {
        this.m_Accepted = false;
        this.registerWindow((Window)this.m_Dialog, this.m_Dialog.getTitle());
        if (this.display(this.m_InputToken)) {
            this.m_Dialog.setVisible(true);
            this.deregisterWindow((Window)this.m_Dialog);
        }
        if (this.m_Accepted) {
            this.m_OutputToken = new Token(this.m_InputToken.getPayload());
        }
        return this.m_Accepted;
    }
}

