/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.exiftagoperation.ApacheCommonsExifTagRead;

public class ExifTagOperation
extends AbstractTransformer {
    private static final long serialVersionUID = 1884823351778616872L;
    protected adams.flow.transformer.exiftagoperation.ExifTagOperation m_Operation;

    public String globalInfo() {
        return "Performs the specified EXIF operation on the incoming data.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("operation", "operation", (Object)new ApacheCommonsExifTagRead());
    }

    public void setOperation(adams.flow.transformer.exiftagoperation.ExifTagOperation value) {
        this.m_Operation = value;
        this.reset();
    }

    public adams.flow.transformer.exiftagoperation.ExifTagOperation getOperation() {
        return this.m_Operation;
    }

    public String operationTipText() {
        return "The operation to execute.";
    }

    public Class[] accepts() {
        return this.m_Operation.accepts();
    }

    public Class[] generates() {
        return this.m_Operation.generates();
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"operation", (Object)this.m_Operation, (String)"operation: ");
    }

    protected String doExecute() {
        String result = null;
        Object input = this.m_InputToken.getPayload();
        MessageCollection errors = new MessageCollection();
        try {
            Object output = this.m_Operation.process(input, errors);
            if (errors.isEmpty() && output != null) {
                this.m_OutputToken = new Token(output);
            } else {
                result = errors.isEmpty() ? "Failed to perform EXIF operation " + this.m_Operation + " on: " + input : "Failed to perform EXIF operation " + this.m_Operation + " on: " + input + "\n" + errors;
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to perform EXIF operation " + this.m_Operation + " on: " + input, e);
        }
        return result;
    }
}

