/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseRegExp;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.data.image.AbstractImageContainer;
import adams.data.io.input.AbstractImageReader;
import adams.data.io.input.AbstractReportReader;
import adams.data.io.input.DefaultSimpleReportReader;
import adams.data.io.input.JAIImageReader;
import adams.data.report.Report;
import adams.flow.core.Token;
import adams.flow.source.filesystemsearch.LocalFileSearch;
import adams.flow.transformer.AbstractTransformer;
import java.io.File;
import java.util.List;
import java.util.logging.Level;

public class ImageFileReader
extends AbstractTransformer {
    private static final long serialVersionUID = 7466006970025235243L;
    protected AbstractImageReader m_Reader;
    protected boolean m_LoadMetaData;
    protected MetaDataLocation m_MetaDataLocation;
    protected AbstractReportReader m_MetaDataReader;

    public String globalInfo() {
        return "Reads any file format that the specified image reader supports.\nIf meta-data is associated with the image, then this can be loaded as well.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("reader", "reader", (Object)new JAIImageReader());
        this.m_OptionManager.add("load-meta-data", "loadMetaData", (Object)false);
        this.m_OptionManager.add("meta-data-location", "metaDataLocation", (Object)MetaDataLocation.SAME_NAME);
        this.m_OptionManager.add("meta-data-reader", "metaDataReader", (Object)new DefaultSimpleReportReader());
    }

    public void setReader(AbstractImageReader value) {
        this.m_Reader = value;
        this.reset();
    }

    public AbstractImageReader getReader() {
        return this.m_Reader;
    }

    public String readerTipText() {
        return "The image reader to use.";
    }

    public void setLoadMetaData(boolean value) {
        this.m_LoadMetaData = value;
        this.reset();
    }

    public boolean getLoadMetaData() {
        return this.m_LoadMetaData;
    }

    public String loadMetaDataTipText() {
        return "If enabled, loading of meta-data is attempted.";
    }

    public void setMetaDataLocation(MetaDataLocation value) {
        this.m_MetaDataLocation = value;
        this.reset();
    }

    public MetaDataLocation getMetaDataLocation() {
        return this.m_MetaDataLocation;
    }

    public String metaDataLocationTipText() {
        return "The location of the meta-data.";
    }

    public void setMetaDataReader(AbstractReportReader value) {
        this.m_MetaDataReader = value;
        this.reset();
    }

    public AbstractReportReader getMetaDataReader() {
        return this.m_MetaDataReader;
    }

    public String metaDataReaderTipText() {
        return "The reader to use for the meta-data.";
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    public Class[] generates() {
        return new Class[]{AbstractImageContainer.class};
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"reader", (Object)this.m_Reader);
        if (this.m_LoadMetaData) {
            result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"metaDataLocation", (Object)((Object)this.m_MetaDataLocation), (String)", location: ");
            result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"metaDataReader", (Object)this.m_MetaDataReader, (String)", meta-data: ");
        }
        return result;
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null && !this.m_Reader.isAvailable()) {
            result = "Reader '" + this.m_Reader.getClass().getName() + "' is not available - check setup!";
        }
        return result;
    }

    protected PlaceholderFile[] listMetaDataFiles(PlaceholderFile imageFile) {
        PlaceholderFile[] result = new PlaceholderFile[]{};
        switch (this.m_MetaDataLocation) {
            case SAME_NAME: {
                PlaceholderFile file = FileUtils.replaceExtension((PlaceholderFile)imageFile, (String)("." + this.m_MetaDataReader.getDefaultFormatExtension()));
                if (!file.exists()) break;
                result = new PlaceholderFile[]{file};
                break;
            }
            case STARTING_WITH: {
                LocalFileSearch search = new LocalFileSearch();
                search.setDirectory(new PlaceholderDirectory(imageFile.getParentFile()));
                search.setRecursive(false);
                search.setRegExp(new BaseRegExp(FileUtils.replaceExtension((String)imageFile.getName(), (String)"") + ".*\\." + this.m_MetaDataReader.getDefaultFormatExtension()));
                try {
                    List matches = search.search();
                    result = new PlaceholderFile[matches.size()];
                    for (int i = 0; i < matches.size(); ++i) {
                        result[i] = new PlaceholderFile((String)matches.get(i));
                    }
                    break;
                }
                catch (Exception e) {
                    this.getLogger().log(Level.SEVERE, "Failed to locate meta-data files using: " + search.toCommandLine(), (Throwable)e);
                    result = new PlaceholderFile[]{};
                    break;
                }
            }
            default: {
                throw new IllegalStateException("Unhandled meta-data location: " + (Object)((Object)this.m_MetaDataLocation));
            }
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        PlaceholderFile file = this.m_InputToken.getPayload() instanceof String ? new PlaceholderFile((String)this.m_InputToken.getPayload()) : new PlaceholderFile((File)this.m_InputToken.getPayload());
        AbstractImageContainer cont = null;
        try {
            cont = this.m_Reader.read(file);
            if (cont != null) {
                this.m_OutputToken = new Token((Object)cont);
            } else {
                result = "Failed to read image: " + file;
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to read image: " + file, e);
        }
        if (this.m_LoadMetaData && result == null) {
            PlaceholderFile[] metaFiles = this.listMetaDataFiles(file);
            Report metaData = null;
            for (PlaceholderFile metaFile : metaFiles) {
                this.m_MetaDataReader.setInput(metaFile);
                List reports = this.m_MetaDataReader.read();
                for (Object obj : reports) {
                    Report report = (Report)obj;
                    if (metaData == null) {
                        metaData = report;
                        continue;
                    }
                    metaData.mergeWith(report);
                }
            }
            if (cont != null && metaData != null) {
                cont.getReport().mergeWith(metaData);
            }
        }
        return result;
    }

    public static enum MetaDataLocation {
        SAME_NAME,
        STARTING_WITH;

    }
}

