/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.report.AbstractField;
import adams.data.report.MutableReportHandler;
import adams.data.report.Report;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.locateobjects.LocatedObjects;

public class ImageObjectIndexOffset
extends AbstractTransformer {
    private static final long serialVersionUID = -1086186805796683098L;
    protected String m_Prefix;
    protected int m_Offset;

    public String globalInfo() {
        return "Offsets the object index. Useful when merging multiple reports.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("prefix", "prefix", (Object)"Object.");
        this.m_OptionManager.add("offset", "offset", (Object)0);
    }

    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The report field prefix used in the report.";
    }

    public void setOffset(int value) {
        if (this.getOptionManager().isValid("offset", (Number)value)) {
            this.m_Offset = value;
            this.reset();
        }
    }

    public int getOffset() {
        return this.m_Offset;
    }

    public String offsetTipText() {
        return "The offset for the index.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"prefix", (Object)this.m_Prefix, (String)"prefix: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"offset", (Object)this.m_Offset, (String)", offset: ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Report.class, MutableReportHandler.class};
    }

    public Class[] generates() {
        return new Class[]{Report.class, MutableReportHandler.class};
    }

    protected String doExecute() {
        String result = null;
        Report report = null;
        MutableReportHandler handler = null;
        if (this.m_InputToken.hasPayload(MutableReportHandler.class)) {
            handler = (MutableReportHandler)this.m_InputToken.getPayload(MutableReportHandler.class);
            report = handler.getReport();
        } else if (this.m_InputToken.hasPayload(Report.class)) {
            report = (Report)this.m_InputToken.getPayload(Report.class);
        } else {
            result = this.m_InputToken.unhandledData();
        }
        if (result == null) {
            try {
                LocatedObjects objs = LocatedObjects.fromReport(report, this.m_Prefix);
                Report newReport = objs.toReport(this.m_Prefix, this.m_Offset, true);
                for (AbstractField field : report.getFields()) {
                    if (!field.getName().startsWith(this.m_Prefix)) continue;
                    report.removeValue(field);
                }
                for (AbstractField field : newReport.getFields()) {
                    report.addField(field);
                    report.setValue(field, newReport.getValue(field));
                }
                if (handler != null) {
                    handler.setReport(report);
                    this.m_OutputToken = new Token((Object)handler);
                } else {
                    this.m_OutputToken = new Token((Object)report);
                }
            }
            catch (Exception e) {
                result = this.handleException("Failed to filter objects!", e);
            }
        }
        return result;
    }
}

