/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.ObjectCopyHelper;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.InPlaceProcessing;
import adams.data.image.AbstractImageContainer;
import adams.data.report.AbstractField;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import adams.flow.transformer.negativeregions.AbstractNegativeRegionsGenerator;
import adams.flow.transformer.negativeregions.Null;

public class NegativeRegions
extends AbstractTransformer
implements InPlaceProcessing {
    private static final long serialVersionUID = -4025021848334590237L;
    protected AbstractNegativeRegionsGenerator m_Algorithm;
    protected AbstractNegativeRegionsGenerator m_ActualAlgorithm;
    protected NegativeRegionTransferType m_TransferType;
    protected String m_ObjectPrefix;
    protected String m_ObjectType;
    protected boolean m_NoCopy;
    protected boolean m_NoRegionsNoOutput;

    public String globalInfo() {
        return "Uses the specified generator for generating negative regions for the image passing through.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("algorithm", "algorithm", (Object)new Null());
        this.m_OptionManager.add("transfer-type", "transferType", (Object)NegativeRegionTransferType.ADD);
        this.m_OptionManager.add("object-prefix", "objectPrefix", (Object)"Object.");
        this.m_OptionManager.add("object-type", "objectType", (Object)"");
        this.m_OptionManager.add("no-copy", "noCopy", (Object)false);
        this.m_OptionManager.add("no-regions-no-output", "noRegionsNoOutput", (Object)false);
    }

    protected void reset() {
        super.reset();
        this.m_ActualAlgorithm = null;
    }

    public void setAlgorithm(AbstractNegativeRegionsGenerator value) {
        this.m_Algorithm = value;
        this.reset();
    }

    public AbstractNegativeRegionsGenerator getAlgorithm() {
        return this.m_Algorithm;
    }

    public String algorithmTipText() {
        return "The algorithm to use for generating the negative regions.";
    }

    public void setTransferType(NegativeRegionTransferType value) {
        this.m_TransferType = value;
        this.reset();
    }

    public NegativeRegionTransferType getTransferType() {
        return this.m_TransferType;
    }

    public String transferTypeTipText() {
        return "Determines how to transfer the generated negative regions into the image.";
    }

    public void setObjectPrefix(String value) {
        this.m_ObjectPrefix = value;
        this.reset();
    }

    public String getObjectPrefix() {
        return this.m_ObjectPrefix;
    }

    public String objectPrefixTipText() {
        return "The prefix that the objects are stored under in the report.";
    }

    public void setObjectType(String value) {
        this.m_ObjectType = value;
        this.reset();
    }

    public String getObjectType() {
        return this.m_ObjectType;
    }

    public String objectTypeTipText() {
        return "Defines the 'type' to use for the negative region objects (and stored in report), ignored if empty.";
    }

    public void setNoCopy(boolean value) {
        this.m_NoCopy = value;
        this.reset();
    }

    public boolean getNoCopy() {
        return this.m_NoCopy;
    }

    public String noCopyTipText() {
        return "If enabled, no copy of the image container is created before adding the regions.";
    }

    public void setNoRegionsNoOutput(boolean value) {
        this.m_NoRegionsNoOutput = value;
        this.reset();
    }

    public boolean getNoRegionsNoOutput() {
        return this.m_NoRegionsNoOutput;
    }

    public String noRegionsNoOutputTipText() {
        return "If enabled, no container is forwarded if no negative regions were generated.";
    }

    public Class[] accepts() {
        return new Class[]{AbstractImageContainer.class};
    }

    public Class[] generates() {
        return new Class[]{AbstractImageContainer.class};
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"algorithm", (Object)((Object)this.m_Algorithm), (String)"algorithm: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"transferType", (Object)((Object)this.m_TransferType), (String)", transfer: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"objectPrefix", (Object)this.m_ObjectPrefix, (String)", object prefix: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"objectType", (Object)(this.m_ObjectType.isEmpty() ? "-none-" : this.m_ObjectType), (String)", object type: ");
        return result;
    }

    protected String doExecute() {
        String result = null;
        AbstractImageContainer cont = (AbstractImageContainer)this.m_InputToken.getPayload(AbstractImageContainer.class);
        LocatedObjects regions = null;
        if (this.m_ActualAlgorithm == null) {
            this.m_ActualAlgorithm = (AbstractNegativeRegionsGenerator)((Object)ObjectCopyHelper.copyObject((Object)((Object)this.m_Algorithm)));
        }
        try {
            regions = this.m_ActualAlgorithm.generateRegions(cont);
            if (this.isLoggingEnabled()) {
                this.getLogger().info("# negative regions generated: " + regions.size());
            }
            if (!this.m_ObjectType.isEmpty()) {
                for (LocatedObject obj : regions) {
                    obj.getMetaData().put("type", this.m_ObjectType);
                }
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to generate negative regions!", e);
        }
        if (this.m_NoRegionsNoOutput && regions != null && regions.size() == 0) {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("No regions generated, suppressing output.");
            }
            return null;
        }
        if (result == null) {
            if (!this.m_NoCopy) {
                cont = (AbstractImageContainer)cont.getClone();
            }
            LocatedObjects current = this.m_TransferType == NegativeRegionTransferType.ADD ? LocatedObjects.fromReport(cont.getReport(), this.m_ObjectPrefix) : new LocatedObjects();
            for (AbstractField field : cont.getReport().getFields()) {
                if (!field.getName().startsWith(this.m_ObjectPrefix)) continue;
                cont.getReport().removeValue(field);
            }
            current.addAll(regions);
            cont.getReport().mergeWith(current.toReport(this.m_ObjectPrefix, 0, true));
            if (!this.isStopped()) {
                this.m_OutputToken = new Token((Object)cont);
            }
        }
        return result;
    }

    public void stopExecution() {
        if (this.m_ActualAlgorithm != null) {
            this.m_ActualAlgorithm.stopExecution();
        }
        super.stopExecution();
    }

    public static enum NegativeRegionTransferType {
        ADD,
        REPLACE;

    }
}

