/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.compareobjectlocations;

import adams.data.image.AbstractImageContainer;
import adams.data.report.Report;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseToggleButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;

public abstract class AbstractComparisonPanel
extends BasePanel {
    private static final long serialVersionUID = 5857461459837580117L;
    protected JPanel m_PanelLabels;
    protected List<BaseToggleButton> m_ButtonLabels;
    protected ButtonGroup m_ButtonGroup;
    protected String m_LastLabel;
    protected String m_AnnotationsPrefix;
    protected String m_PredictionsPrefix;

    protected void initialize() {
        super.initialize();
        this.m_ButtonLabels = new ArrayList<BaseToggleButton>();
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel(new BorderLayout());
        this.add(panel, "West");
        this.m_PanelLabels = new JPanel(new GridBagLayout());
        panel.add((Component)new BaseScrollPane((Component)this.m_PanelLabels), "Center");
        this.m_ButtonGroup = new ButtonGroup();
    }

    public void setAnnotationsPrefix(String value) {
        this.m_AnnotationsPrefix = value;
    }

    public void setPredictionsPrefix(String value) {
        this.m_PredictionsPrefix = value;
    }

    protected Report filterObjects(String label, LocatedObjects objects, String suffix, String prefix) {
        if (label == null) {
            label = "";
        }
        if (label.isEmpty()) {
            return objects.toReport(prefix);
        }
        LocatedObjects filtered = new LocatedObjects();
        for (LocatedObject obj : objects) {
            if (!obj.getMetaData().containsKey(suffix) || !obj.getMetaData().get(suffix).toString().equals(label)) continue;
            filtered.add(obj.getClone());
        }
        return filtered.toReport(prefix);
    }

    protected abstract void filterObjects(String var1);

    protected void updateButtons(List<String> labels) {
        GridBagConstraints con;
        int gapHorizontal = 5;
        int gapVertical = 2;
        GridBagLayout layout = new GridBagLayout();
        this.m_PanelLabels.setLayout(layout);
        for (BaseToggleButton b : this.m_ButtonLabels) {
            this.m_ButtonGroup.remove((AbstractButton)b);
        }
        this.m_ButtonLabels.clear();
        this.m_PanelLabels.removeAll();
        BaseToggleButton button = new BaseToggleButton("All");
        button.addActionListener(e -> this.filterObjects(""));
        button.setToolTipText(button.getText());
        this.m_ButtonGroup.add((AbstractButton)button);
        this.m_ButtonLabels.add(button);
        for (String label : labels) {
            button = new BaseToggleButton(label);
            button.addActionListener(e -> this.filterObjects(label));
            button.setToolTipText(button.getText());
            this.m_ButtonGroup.add((AbstractButton)button);
            this.m_ButtonLabels.add(button);
        }
        for (int i = 0; i < this.m_ButtonLabels.size(); ++i) {
            con = new GridBagConstraints();
            con.anchor = 17;
            con.fill = 2;
            con.gridy = i;
            con.gridx = 0;
            con.weightx = 100.0;
            con.ipadx = 20;
            con.insets = new Insets(gapVertical, gapHorizontal, gapVertical, gapHorizontal);
            layout.setConstraints((Component)this.m_ButtonLabels.get(i), con);
            this.m_PanelLabels.add((Component)this.m_ButtonLabels.get(i));
        }
        JPanel panel = new JPanel();
        con = new GridBagConstraints();
        con.anchor = 17;
        con.fill = 1;
        con.gridy = this.m_ButtonLabels.size();
        con.gridx = 0;
        con.weighty = 100.0;
        con.gridwidth = 0;
        layout.setConstraints(panel, con);
        this.m_PanelLabels.add(panel);
        if (!labels.contains(this.m_LastLabel)) {
            this.m_LastLabel = "";
        }
        if (this.m_LastLabel.isEmpty()) {
            this.m_ButtonLabels.get(0).doClick();
        } else if (labels.contains(this.m_LastLabel)) {
            this.m_ButtonLabels.get(labels.indexOf(this.m_LastLabel) + 1).doClick();
        }
    }

    public abstract void clearPanel();

    public abstract void display(AbstractImageContainer var1, List<String> var2, Report var3, LocatedObjects var4, Report var5, LocatedObjects var6);
}

