/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.compareobjectlocations;

import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.data.image.AbstractImageContainer;
import adams.data.objectoverlap.LabelAwareObjectOverlap;
import adams.data.objectoverlap.Null;
import adams.data.objectoverlap.ObjectOverlap;
import adams.data.report.Report;
import adams.flow.transformer.CompareObjectLocations;
import adams.flow.transformer.compareobjectlocations.AbstractComparison;
import adams.flow.transformer.compareobjectlocations.AbstractComparisonPanel;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import adams.gui.core.ColorHelper;
import adams.gui.visualization.image.ImageOverlay;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.MultiImageOverlay;
import adams.gui.visualization.image.ObjectLocationsOverlayFromReport;
import com.github.fracpete.javautils.struct.Struct2;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class Combined
extends AbstractComparison {
    private static final long serialVersionUID = -6214679316931952392L;
    protected Color m_AnnotationsColor;
    protected Color m_PredictionsColor;
    protected ObjectOverlap m_ObjectOverlap;
    protected Color m_OverlapColorCorrect;
    protected Color m_OverlapColorIncorrect;
    protected double m_Zoom;

    public String globalInfo() {
        return "Displays the annotations and predictions with different colors.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("annotations-color", "annotationsColor", (Object)Color.BLUE);
        this.m_OptionManager.add("predictions-color", "predictionsColor", (Object)Color.RED);
        this.m_OptionManager.add("object-overlap", "objectOverlap", (Object)new Null());
        this.m_OptionManager.add("overlap-color-correct", "overlapColorCorrect", (Object)ColorHelper.addAlpha((Color)Color.GREEN, (int)64));
        this.m_OptionManager.add("overlap-color-incorrect", "overlapColorIncorrect", (Object)ColorHelper.addAlpha((Color)ColorHelper.invert((Color)Color.GREEN), (int)64));
        this.m_OptionManager.add("zoom", "zoom", (Object)100.0, (Number)-1.0, (Number)1600.0);
    }

    public void setAnnotationsColor(Color value) {
        this.m_AnnotationsColor = value;
        this.reset();
    }

    public Color getAnnotationsColor() {
        return this.m_AnnotationsColor;
    }

    public String annotationsColorTipText() {
        return "The color to use for the annotations.";
    }

    public void setPredictionsColor(Color value) {
        this.m_PredictionsColor = value;
        this.reset();
    }

    public Color getPredictionsColor() {
        return this.m_PredictionsColor;
    }

    public String predictionsColorTipText() {
        return "The color to use for the predictions.";
    }

    public void setObjectOverlap(ObjectOverlap value) {
        this.m_ObjectOverlap = value;
        this.reset();
    }

    public ObjectOverlap getObjectOverlap() {
        return this.m_ObjectOverlap;
    }

    public String objectOverlapTipText() {
        return "The algorithm to use for determining overlapping objects.";
    }

    public void setOverlapColorCorrect(Color value) {
        this.m_OverlapColorCorrect = value;
        this.reset();
    }

    public Color getOverlapColorCorrect() {
        return this.m_OverlapColorCorrect;
    }

    public String overlapColorCorrectTipText() {
        return "The color to use for the overlapping objects with matching labels.";
    }

    public void setOverlapColorIncorrect(Color value) {
        this.m_OverlapColorIncorrect = value;
        this.reset();
    }

    public Color getOverlapColorIncorrect() {
        return this.m_OverlapColorIncorrect;
    }

    public String overlapColorIncorrectTipText() {
        return "The color to use for the overlapping objects with matching labels.";
    }

    public void setZoom(double value) {
        if (value == -1.0 || value > 0.0 && value <= 1600.0) {
            this.m_Zoom = value;
            this.reset();
        } else {
            this.getLogger().warning("Zoom must -1 to fit window or 0 < x < 1600, provided: " + value);
        }
    }

    public double getZoom() {
        return this.m_Zoom;
    }

    public String zoomTipText() {
        return "The zoom level in percent.";
    }

    @Override
    public AbstractComparisonPanel generate(CompareObjectLocations owner) {
        ObjectLocationsOverlayFromReport annotations = new ObjectLocationsOverlayFromReport();
        annotations.setColor(this.m_AnnotationsColor);
        annotations.setPrefix("Annotation.");
        ObjectLocationsOverlayFromReport predictions = new ObjectLocationsOverlayFromReport();
        predictions.setColor(this.m_PredictionsColor);
        predictions.setPrefix("Prediction.");
        ObjectLocationsOverlayFromReport overlapsCorrect = new ObjectLocationsOverlayFromReport();
        overlapsCorrect.setColor(this.m_OverlapColorCorrect);
        overlapsCorrect.setFilled(true);
        overlapsCorrect.setPrefix("OverlapCorrect.");
        ObjectLocationsOverlayFromReport overlapsIncorrect = new ObjectLocationsOverlayFromReport();
        overlapsIncorrect.setColor(this.m_OverlapColorIncorrect);
        overlapsIncorrect.setFilled(true);
        overlapsIncorrect.setPrefix("OverlapIncorrect.");
        MultiImageOverlay multi = new MultiImageOverlay();
        multi.setOverlays(new ImageOverlay[]{annotations, predictions, overlapsCorrect, overlapsIncorrect});
        CombinedPanel result = new CombinedPanel();
        result.setOverlay((ImageOverlay)multi);
        result.setAnnotationsColor(this.m_AnnotationsColor);
        result.setPredictionsColor(this.m_PredictionsColor);
        result.setObjectOverlap((ObjectOverlap)OptionUtils.shallowCopy((OptionHandler)this.m_ObjectOverlap, (boolean)true));
        result.setOverlapColorCorrect(this.m_OverlapColorCorrect);
        result.setOverlapColorIncorrect(this.m_OverlapColorIncorrect);
        result.setZoom(this.m_Zoom);
        return result;
    }

    public static class CombinedPanel
    extends AbstractComparisonPanel {
        private static final long serialVersionUID = 385817392712324238L;
        public static final String SUFFIX_TYPE = "type";
        public static final String PREFIX_ANNOTATION = "Annotation.";
        public static final String PREFIX_PREDICTION = "Prediction.";
        public static final String PREFIX_OVERLAP_CORRECT = "OverlapCorrect.";
        public static final String PREFIX_OVERLAP_INCORRECT = "OverlapIncorrect.";
        protected ImagePanel m_PanelImage;
        protected JPanel m_PanelColors;
        protected JLabel m_LabelAnnotationsColorBox;
        protected JLabel m_LabelPredictionsColorBox;
        protected JLabel m_LabelOverlapColorCorrectText;
        protected JLabel m_LabelOverlapColorCorrectBox;
        protected JLabel m_LabelOverlapColorIncorrectText;
        protected JLabel m_LabelOverlapColorIncorrectBox;
        protected Report m_AnnotationsReport;
        protected LocatedObjects m_AnnotationsLocatedObjects;
        protected String m_AnnotationsLabelSuffix;
        protected Report m_PredictionsReport;
        protected LocatedObjects m_PredictionsLocatedObjects;
        protected String m_PredictionsLabelSuffix;
        protected ObjectOverlap m_ObjectOverlap;
        protected LocatedObjects m_OverlapLocatedObjectsCorrect;
        protected LocatedObjects m_OverlapLocatedObjectsIncorrect;
        protected double m_Zoom;
        protected Report m_CombinedReport;

        @Override
        protected void initialize() {
            super.initialize();
            this.m_CombinedReport = new Report();
        }

        @Override
        protected void initGUI() {
            super.initGUI();
            this.m_PanelImage = new ImagePanel();
            this.add((Component)this.m_PanelImage, "Center");
            this.m_PanelColors = new JPanel(new FlowLayout(0));
            this.add(this.m_PanelColors, "South");
            this.m_LabelAnnotationsColorBox = new JLabel("         ");
            this.m_LabelAnnotationsColorBox.setOpaque(true);
            this.m_LabelPredictionsColorBox = new JLabel("         ");
            this.m_LabelPredictionsColorBox.setOpaque(true);
            this.m_LabelOverlapColorCorrectText = new JLabel("Overlaps (match)");
            this.m_LabelOverlapColorCorrectBox = new JLabel("         ");
            this.m_LabelOverlapColorCorrectBox.setOpaque(true);
            this.m_LabelOverlapColorIncorrectText = new JLabel("Overlaps (mismatch)");
            this.m_LabelOverlapColorIncorrectBox = new JLabel("         ");
            this.m_LabelOverlapColorIncorrectBox.setOpaque(true);
            this.m_PanelColors.add(new JLabel("Annotations"));
            this.m_PanelColors.add(this.m_LabelAnnotationsColorBox);
            this.m_PanelColors.add(new JLabel("Predictions"));
            this.m_PanelColors.add(this.m_LabelPredictionsColorBox);
            this.m_PanelColors.add(this.m_LabelOverlapColorCorrectText);
            this.m_PanelColors.add(this.m_LabelOverlapColorCorrectBox);
            this.m_PanelColors.add(this.m_LabelOverlapColorIncorrectText);
            this.m_PanelColors.add(this.m_LabelOverlapColorIncorrectBox);
        }

        public void setZoom(double value) {
            this.m_Zoom = value;
        }

        public void setOverlay(ImageOverlay value) {
            this.m_PanelImage.addImageOverlay((ImageOverlay)OptionUtils.shallowCopy((Object)value));
        }

        public void setAnnotationsColor(Color value) {
            this.m_LabelAnnotationsColorBox.setBackground(value);
        }

        public void setPredictionsColor(Color value) {
            this.m_LabelPredictionsColorBox.setBackground(value);
        }

        public void setObjectOverlap(ObjectOverlap value) {
            this.m_ObjectOverlap = value;
            if (this.m_ObjectOverlap instanceof Null) {
                this.m_LabelOverlapColorCorrectText.setVisible(false);
                this.m_LabelOverlapColorCorrectBox.setVisible(false);
            }
        }

        public void setOverlapColorCorrect(Color value) {
            this.m_LabelOverlapColorCorrectBox.setBackground(value);
        }

        public void setOverlapColorIncorrect(Color value) {
            this.m_LabelOverlapColorIncorrectBox.setBackground(value);
        }

        @Override
        public void clearPanel() {
            if (this.m_PanelImage != null) {
                this.m_PanelImage.clear();
            }
        }

        @Override
        protected void filterObjects(String label) {
            Report combined = new Report();
            combined.mergeWith(this.filterObjects(label, this.m_AnnotationsLocatedObjects, SUFFIX_TYPE, PREFIX_ANNOTATION));
            combined.mergeWith(this.filterObjects(label, this.m_PredictionsLocatedObjects, SUFFIX_TYPE, PREFIX_PREDICTION));
            combined.mergeWith(this.filterObjects(label, this.m_OverlapLocatedObjectsCorrect, SUFFIX_TYPE, PREFIX_OVERLAP_CORRECT));
            combined.mergeWith(this.filterObjects(label, this.m_OverlapLocatedObjectsIncorrect, SUFFIX_TYPE, PREFIX_OVERLAP_INCORRECT));
            this.m_PanelImage.setAdditionalProperties(combined);
        }

        protected LocatedObjects updateLabelType(LocatedObjects objects, String suffix) {
            LocatedObjects result = new LocatedObjects();
            for (LocatedObject obj : objects) {
                result.add(obj.getClone());
            }
            result.renameMetaDataKey(suffix, SUFFIX_TYPE);
            return result;
        }

        @Override
        public void display(AbstractImageContainer cont, List<String> labels, Report repAnn, LocatedObjects objAnn, Report repPred, LocatedObjects objPred) {
            double zoom = this.m_Zoom == -1.0 ? this.m_Zoom : this.m_Zoom / 100.0;
            this.m_AnnotationsReport = repAnn;
            this.m_AnnotationsLocatedObjects = this.updateLabelType(objAnn, this.m_AnnotationsLabelSuffix);
            this.m_PredictionsReport = repPred;
            this.m_PredictionsLocatedObjects = this.updateLabelType(objPred, this.m_PredictionsLabelSuffix);
            if (this.m_ObjectOverlap instanceof Null) {
                this.m_OverlapLocatedObjectsCorrect = new LocatedObjects();
                this.m_OverlapLocatedObjectsIncorrect = new LocatedObjects();
            } else {
                LocatedObjects overlaps = this.m_ObjectOverlap.calculate(this.m_AnnotationsLocatedObjects, this.m_PredictionsLocatedObjects);
                if (this.m_ObjectOverlap instanceof LabelAwareObjectOverlap) {
                    Struct2<LocatedObjects, LocatedObjects> split = ((LabelAwareObjectOverlap)this.m_ObjectOverlap).splitOverlaps(overlaps);
                    this.m_OverlapLocatedObjectsCorrect = (LocatedObjects)split.value1;
                    this.m_OverlapLocatedObjectsIncorrect = (LocatedObjects)split.value2;
                } else {
                    this.m_OverlapLocatedObjectsCorrect = overlaps;
                    this.m_OverlapLocatedObjectsIncorrect = new LocatedObjects();
                }
            }
            this.m_CombinedReport = new Report();
            this.m_CombinedReport.mergeWith(this.m_AnnotationsLocatedObjects.toReport(PREFIX_ANNOTATION));
            this.m_CombinedReport.mergeWith(this.m_PredictionsLocatedObjects.toReport(PREFIX_PREDICTION));
            this.m_CombinedReport.mergeWith(this.m_OverlapLocatedObjectsCorrect.toReport(PREFIX_OVERLAP_CORRECT));
            this.m_CombinedReport.mergeWith(this.m_OverlapLocatedObjectsIncorrect.toReport(PREFIX_OVERLAP_INCORRECT));
            this.m_PanelImage.setCurrentImage(cont);
            this.m_PanelImage.setAdditionalProperties(this.m_CombinedReport);
            this.m_PanelImage.setScale(zoom);
            this.updateButtons(labels);
        }
    }
}

