/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.compareobjectlocations;

import adams.core.option.OptionUtils;
import adams.data.image.AbstractImageContainer;
import adams.data.report.Report;
import adams.flow.transformer.CompareObjectLocations;
import adams.flow.transformer.compareobjectlocations.AbstractComparison;
import adams.flow.transformer.compareobjectlocations.AbstractComparisonPanel;
import adams.flow.transformer.locateobjects.LocatedObjects;
import adams.gui.core.BaseSplitPane;
import adams.gui.visualization.image.ImageOverlay;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.ObjectLocationsOverlayFromReport;
import java.awt.Component;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.border.Border;

public class SideBySide
extends AbstractComparison {
    private static final long serialVersionUID = 1595413312168655696L;
    protected ImageOverlay m_AnnotationsOverlay;
    protected ImageOverlay m_PredictionsOverlay;
    protected double m_Zoom;

    public String globalInfo() {
        return "Generates a side-by-side comparison.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("annotations-overlay", "annotationsOverlay", (Object)new ObjectLocationsOverlayFromReport());
        this.m_OptionManager.add("predictions-overlay", "predictionsOverlay", (Object)new ObjectLocationsOverlayFromReport());
        this.m_OptionManager.add("zoom", "zoom", (Object)100.0, (Number)-1.0, (Number)1600.0);
    }

    public void setAnnotationsOverlay(ImageOverlay value) {
        this.m_AnnotationsOverlay = value;
        this.reset();
    }

    public ImageOverlay getAnnotationsOverlay() {
        return this.m_AnnotationsOverlay;
    }

    public String annotationsOverlayTipText() {
        return "The overlay to apply to the annotations.";
    }

    public void setPredictionsOverlay(ImageOverlay value) {
        this.m_PredictionsOverlay = value;
        this.reset();
    }

    public ImageOverlay getPredictionsOverlay() {
        return this.m_PredictionsOverlay;
    }

    public String predictionsOverlayTipText() {
        return "The overlay to apply to the predictions.";
    }

    public void setZoom(double value) {
        if (value == -1.0 || value > 0.0 && value <= 1600.0) {
            this.m_Zoom = value;
            this.reset();
        } else {
            this.getLogger().warning("Zoom must -1 to fit window or 0 < x < 1600, provided: " + value);
        }
    }

    public double getZoom() {
        return this.m_Zoom;
    }

    public String zoomTipText() {
        return "The zoom level in percent.";
    }

    @Override
    public AbstractComparisonPanel generate(CompareObjectLocations owner) {
        SideBySidePanel result = new SideBySidePanel();
        result.setZoom(this.m_Zoom);
        result.setAnnotationsOverlay(this.m_AnnotationsOverlay);
        result.setAnnotationsPrefix(owner.getAnnotationsPrefix());
        result.setAnnotationsLabelSuffix(owner.getAnnotationsLabelSuffix());
        result.setPredictionsOverlay(this.m_PredictionsOverlay);
        result.setPredictionsPrefix(owner.getPredictionsPrefix());
        result.setPredictionsLabelSuffix(owner.getPredictionsLabelSuffix());
        return result;
    }

    public static class SideBySidePanel
    extends AbstractComparisonPanel {
        private static final long serialVersionUID = -4668850944632082746L;
        protected BaseSplitPane m_SplitPane;
        protected ImagePanel m_PanelImageAnnotations;
        protected ImagePanel m_PanelImagePredictions;
        protected Report m_AnnotationsReport;
        protected LocatedObjects m_AnnotationsLocatedObjects;
        protected String m_AnnotationsLabelSuffix;
        protected Report m_PredictionsReport;
        protected LocatedObjects m_PredictionsLocatedObjects;
        protected String m_PredictionsLabelSuffix;
        protected double m_Zoom;

        @Override
        protected void initialize() {
            super.initialize();
            this.m_AnnotationsReport = new Report();
            this.m_AnnotationsLocatedObjects = new LocatedObjects();
            this.m_PredictionsReport = new Report();
            this.m_PredictionsLocatedObjects = new LocatedObjects();
        }

        @Override
        protected void initGUI() {
            super.initGUI();
            this.m_SplitPane = new BaseSplitPane(1);
            this.m_SplitPane.setResizeWeight(0.5);
            this.add((Component)this.m_SplitPane, "Center");
            this.m_PanelImageAnnotations = new ImagePanel();
            this.m_PanelImageAnnotations.setBorder((Border)BorderFactory.createTitledBorder("Annotations"));
            this.m_SplitPane.setLeftComponent((Component)this.m_PanelImageAnnotations);
            this.m_PanelImagePredictions = new ImagePanel();
            this.m_PanelImagePredictions.setBorder((Border)BorderFactory.createTitledBorder("Predictions"));
            this.m_SplitPane.setRightComponent((Component)this.m_PanelImagePredictions);
        }

        public void setZoom(double value) {
            this.m_Zoom = value;
        }

        public void setAnnotationsOverlay(ImageOverlay value) {
            this.m_PanelImageAnnotations.addImageOverlay((ImageOverlay)OptionUtils.shallowCopy((Object)value));
        }

        public void setAnnotationsLabelSuffix(String value) {
            this.m_AnnotationsLabelSuffix = value;
        }

        public void setPredictionsOverlay(ImageOverlay value) {
            this.m_PanelImagePredictions.addImageOverlay((ImageOverlay)OptionUtils.shallowCopy((Object)value));
        }

        public void setPredictionsLabelSuffix(String value) {
            this.m_PredictionsLabelSuffix = value;
        }

        @Override
        protected void filterObjects(String label) {
            this.m_PanelImageAnnotations.setAdditionalProperties(this.filterObjects(label, this.m_AnnotationsLocatedObjects, this.m_AnnotationsLabelSuffix, this.m_AnnotationsPrefix));
            this.m_PanelImagePredictions.setAdditionalProperties(this.filterObjects(label, this.m_PredictionsLocatedObjects, this.m_PredictionsLabelSuffix, this.m_PredictionsPrefix));
        }

        @Override
        public void clearPanel() {
            this.m_PanelImageAnnotations.clear();
            this.m_PanelImagePredictions.clear();
        }

        @Override
        public void display(AbstractImageContainer cont, List<String> labels, Report repAnn, LocatedObjects objAnn, Report repPred, LocatedObjects objPred) {
            double zoom = this.m_Zoom == -1.0 ? this.m_Zoom : this.m_Zoom / 100.0;
            this.m_AnnotationsReport = repAnn;
            this.m_AnnotationsLocatedObjects = objAnn;
            this.m_PanelImageAnnotations.setCurrentImage(cont);
            this.m_PanelImageAnnotations.setAdditionalProperties(this.m_AnnotationsReport);
            this.m_PanelImageAnnotations.setScale(zoom);
            this.m_PredictionsReport = repPred;
            this.m_PredictionsLocatedObjects = objPred;
            this.m_PanelImagePredictions.setCurrentImage(cont);
            this.m_PanelImagePredictions.setAdditionalProperties(this.m_PredictionsReport);
            this.m_PanelImagePredictions.setScale(zoom);
            this.updateButtons(labels);
        }
    }
}

