/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.locateobjects;

import adams.data.image.BufferedImageHelper;
import adams.data.image.XScreenMaskHelper;
import adams.data.image.transformer.crop.AbstractCropAlgorithm;
import adams.data.image.transformer.crop.NoCrop;
import adams.flow.transformer.locateobjects.AbstractObjectLocator;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.ArrayDeque;
import java.util.logging.Level;
import javax.media.jai.Interpolation;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.ScaleDescriptor;

public class XScreenMaskLocator
extends AbstractObjectLocator {
    private static final long serialVersionUID = -8858162456921699059L;
    protected int m_MinSize;
    protected int m_MaxSize;
    protected AbstractCropAlgorithm m_Crop;
    protected double m_Scale;
    protected XScreenMaskHelper.Color m_Color;
    protected boolean m_Down;
    protected int m_Threshold;

    public String globalInfo() {
        return "Using the XScreenMask, this locator masks out the background plate (similar to a green screening process)then proceeds to find blobs in the resultant image.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("min-size", "minSize", (Object)10, (Number)0, null);
        this.m_OptionManager.add("max-size", "maxSize", (Object)200, (Number)0, null);
        this.m_OptionManager.add("crop", "crop", (Object)new NoCrop());
        this.m_OptionManager.add("scale", "scale", (Object)0.2, (Number)0.1, (Number)1.0);
        this.m_OptionManager.add("color", "color", (Object)XScreenMaskHelper.Color.RED);
        this.m_OptionManager.add("down", "down", (Object)true);
        this.m_OptionManager.add("threshold", "threshold", (Object)-1, (Number)-1, (Number)255);
    }

    public int getMinSize() {
        return this.m_MinSize;
    }

    public void setMinSize(int value) {
        if (value >= 0) {
            this.m_MinSize = value;
            this.reset();
        } else {
            this.getLogger().severe("Minimum size must be >= 0, provided: " + value);
        }
    }

    public String minSizeTipText() {
        return "Minimum object size.";
    }

    public int getMaxSize() {
        return this.m_MaxSize;
    }

    public void setMaxSize(int value) {
        if (value >= 0) {
            this.m_MaxSize = value;
            this.reset();
        } else {
            this.getLogger().severe("Maximum size must be >= 0, provided: " + value);
        }
    }

    public String maxSizeTipText() {
        return "Maximum object size.";
    }

    public AbstractCropAlgorithm getCrop() {
        return this.m_Crop;
    }

    public void setCrop(AbstractCropAlgorithm value) {
        if (value != null) {
            this.m_Crop = value;
            this.reset();
        } else {
            this.getLogger().severe("Cropping algorithm must not be null.");
        }
    }

    public String cropTipText() {
        return "Cropping algorithm.";
    }

    public double getScale() {
        return this.m_Scale;
    }

    public void setScale(double value) {
        if (value >= 0.1 && value <= 1.0) {
            this.m_Scale = value;
            this.reset();
        } else {
            this.getLogger().severe("Scale must be 0.1 <= value >= 1, provided: " + value);
        }
    }

    public String scaleTipText() {
        return "Scale factor of working image (decrease scale for speed, increase for accuracy).";
    }

    public XScreenMaskHelper.Color getColor() {
        return this.m_Color;
    }

    public void setColor(XScreenMaskHelper.Color value) {
        if (value != null) {
            this.m_Color = value;
            this.reset();
        } else {
            this.getLogger().severe("Color must not be null.");
        }
    }

    public String colorTipText() {
        return "Color to be masked out.";
    }

    public boolean getDown() {
        return this.m_Down;
    }

    public void setDown(boolean value) {
        this.m_Down = value;
        this.reset();
    }

    public String downTipText() {
        return "If true, then pixels <= threshold are not masked and the others' alpha channel are set to 0 (made transparent).";
    }

    public int getThreshold() {
        return this.m_Threshold;
    }

    public void setThreshold(int value) {
        if (value >= -1 && value <= 255) {
            this.m_Threshold = value;
            this.reset();
        } else {
            this.getLogger().severe("Threshold must be 0 >= value <= 255, or -1 for auto-thresholding, provided: " + value);
        }
    }

    public String thresholdTipText() {
        return "Threshold value used for binarization, specify -1 to automatically determine a threshold.";
    }

    @Override
    protected LocatedObjects doLocate(BufferedImage image, boolean annotateOnly) {
        BufferedImage tmp = BufferedImageHelper.deepCopy((BufferedImage)image);
        tmp = this.m_Crop.crop(tmp);
        Point offset = this.m_Crop.getTopLeft();
        if (this.m_Scale != 1.0) {
            RenderedOp renderedOp = ScaleDescriptor.create((RenderedImage)tmp, (Float)Float.valueOf((float)this.m_Scale), (Float)Float.valueOf((float)this.m_Scale), (Float)Float.valueOf(0.0f), (Float)Float.valueOf(0.0f), (Interpolation)Interpolation.getInstance((int)0), null);
            tmp = renderedOp.getAsBufferedImage(new Rectangle(0, 0, (int)Math.floor((double)image.getWidth() * this.m_Scale), (int)Math.floor((double)image.getHeight() * this.m_Scale)), null);
        }
        int[][] mask = XScreenMaskHelper.generateMask(tmp, this.m_Color);
        XScreenMaskHelper.binarizeMask(mask, this.m_Threshold, this.m_Down, this.getLogger());
        LocatedObjects objects = new LocatedObjects();
        for (int y = 0; y < mask.length; ++y) {
            for (int x = 0; x < mask[0].length; ++x) {
                int[] rect = this.boundingBox(mask, x, y);
                if (rect == null) continue;
                int left = (int)((double)Math.round((double)rect[0] / this.m_Scale) + offset.getX());
                int top = (int)((double)Math.round((double)rect[1] / this.m_Scale) + offset.getY());
                int width = (int)Math.round((double)(rect[2] - rect[0] + 1) / this.m_Scale);
                int height = (int)Math.round((double)(rect[3] - rect[1] + 1) / this.m_Scale);
                if (width < this.m_MinSize || width > this.m_MaxSize || height < this.m_MinSize || height > this.m_MaxSize || left + width >= image.getWidth() || top + height >= image.getHeight()) continue;
                try {
                    objects.add(new LocatedObject(annotateOnly ? null : image.getSubimage(left, top, width, height), left, top, width, height));
                    continue;
                }
                catch (Exception e) {
                    this.getLogger().log(Level.SEVERE, "Failed to create location using: imgwidth=" + image.getWidth() + ", imgheight=" + image.getHeight() + ", left=" + left + ", top=" + top + ", width=" + width + ", height=" + height + ", scale=" + this.m_Scale, (Throwable)e);
                }
            }
        }
        return objects;
    }

    protected int[] boundingBox(int[][] mask, int xStart, int yStart) {
        if (mask[yStart][xStart] != 1) {
            return null;
        }
        int width = mask[0].length;
        int height = mask.length;
        int[] node = new int[]{xStart, yStart};
        ArrayDeque<int[]> stack = new ArrayDeque<int[]>();
        stack.push(node);
        int left = width - 1;
        int right = 0;
        int top = height - 1;
        int bottom = 0;
        while ((node = (int[])stack.pollFirst()) != null) {
            int west;
            int y = node[1];
            int east = node[0];
            for (west = node[0]; west > 0 && mask[y][west - 1] == 1; --west) {
            }
            while (east < width - 1 && mask[y][east + 1] == 1) {
                ++east;
            }
            for (int x = west; x <= east; ++x) {
                mask[y][x] = -1;
                if (y > 0 && mask[y - 1][x] == 1) {
                    stack.push(new int[]{x, y - 1});
                }
                if (y >= height - 1 || mask[y + 1][x] != 1) continue;
                stack.push(new int[]{x, y + 1});
            }
            if (west < left) {
                left = west;
            }
            if (east > right) {
                right = east;
            }
            if (y < top) {
                top = y;
            }
            if (y <= bottom) continue;
            bottom = y;
        }
        return new int[]{left, top, right, bottom};
    }
}

