/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.negativeregions;

import adams.data.RoundingType;
import adams.data.image.AbstractImageContainer;
import adams.data.image.IntArrayMatrixView;
import adams.data.objectfilter.Scale;
import adams.data.objectfinder.AllFinder;
import adams.data.objectfinder.ObjectFinder;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import adams.flow.transformer.negativeregions.AbstractNegativeRegionsGenerator;
import java.awt.Color;

public class SimpleBlockFill
extends AbstractNegativeRegionsGenerator {
    private static final long serialVersionUID = -3098590558581645598L;
    public static final int ANNOTATION = Color.WHITE.getRGB();
    public static final int NEGATIVE = Color.RED.getRGB();
    protected ObjectFinder m_Finder;
    protected int m_NumCols;
    protected int m_NumRows;
    protected double m_ScaleFactor;

    public String globalInfo() {
        return "Finds largest blocks from starting points on grid.\nGenerates a grid of starting points, removes any starting points that fall within existing annotations. From these starting points, it find largest blocks in x and y. Once regions have been located, overlaps get removed.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("finder", "finder", (Object)new AllFinder());
        this.m_OptionManager.add("num-cols", "numCols", (Object)20, (Number)1, null);
        this.m_OptionManager.add("num-rows", "numRows", (Object)15, (Number)1, null);
        this.m_OptionManager.add("scale-factor", "scaleFactor", (Object)1.0, (Number)1.0E-4, null);
    }

    public void setFinder(ObjectFinder value) {
        this.m_Finder = value;
        this.reset();
    }

    public ObjectFinder getFinder() {
        return this.m_Finder;
    }

    public String finderTipText() {
        return "The object finder to use for locating objects in the report.";
    }

    public void setNumCols(int value) {
        if (this.getOptionManager().isValid("numCols", (Number)value)) {
            this.m_NumCols = value;
            this.reset();
        }
    }

    public int getNumCols() {
        return this.m_NumCols;
    }

    public String numColsTipText() {
        return "The number of columns in the grid for starting points.";
    }

    public void setNumRows(int value) {
        if (this.getOptionManager().isValid("numRows", (Number)value)) {
            this.m_NumRows = value;
            this.reset();
        }
    }

    public int getNumRows() {
        return this.m_NumRows;
    }

    public String numRowsTipText() {
        return "The number of rows in the grid for starting points.";
    }

    public void setScaleFactor(double value) {
        if (this.getOptionManager().isValid("scaleFactor", (Number)value)) {
            this.m_ScaleFactor = value;
            this.reset();
        }
    }

    public double getScaleFactor() {
        return this.m_ScaleFactor;
    }

    public String scaleFactorTipText() {
        return "The scale factor to use on the image.";
    }

    protected void findExtent(IntArrayMatrixView matrix, int s, int t, boolean horizontal, int[] ext) {
        ext[0] = -1;
        ext[1] = -1;
        if (horizontal) {
            int x = s;
            while (x >= 0 && matrix.get(x, t) == 0) {
                ext[0] = x--;
            }
            x = s;
            while (x < matrix.getWidth() && matrix.get(x, t) == 0) {
                ext[1] = x++;
            }
        } else {
            int y = t;
            while (y >= 0 && matrix.get(s, y) == 0) {
                ext[0] = y--;
            }
            y = t;
            while (y < matrix.getHeight() && matrix.get(s, y) == 0) {
                ext[1] = y++;
            }
        }
    }

    protected boolean isValidExtent(int[] ext) {
        return ext[0] > -1 && ext[1] > -1 && ext[0] <= ext[1];
    }

    protected void fillInArea(IntArrayMatrixView matrix, LocatedObject obj, int color) {
        if (obj.getX() < 0 || obj.getX() >= matrix.getWidth()) {
            this.getLogger().warning("X outside: " + obj.getX() + " - [0; " + (matrix.getWidth() - 1) + "]");
            return;
        }
        if (obj.getY() < 0 || obj.getY() >= matrix.getHeight()) {
            this.getLogger().warning("Y outside: " + obj.getY() + " - [0; " + (matrix.getHeight() - 1) + "]");
            return;
        }
        if (obj.getWidth() < 0 || obj.getX() + obj.getWidth() > matrix.getWidth()) {
            this.getLogger().warning("X+Width outside: " + (obj.getX() + obj.getWidth()) + " - [0; " + (matrix.getWidth() - 1) + "]");
            return;
        }
        if (obj.getHeight() < 0 || obj.getY() + obj.getHeight() > matrix.getHeight()) {
            this.getLogger().warning("Y+Height outside: " + (obj.getY() + obj.getHeight()) + " - [0; " + (matrix.getHeight() - 1) + "]");
            return;
        }
        for (int y = obj.getY(); y < obj.getY() + obj.getHeight() && y < matrix.getHeight(); ++y) {
            for (int x = obj.getX(); x < obj.getX() + obj.getWidth() && x < matrix.getWidth(); ++x) {
                matrix.set(x, y, color);
            }
        }
    }

    @Override
    protected LocatedObjects doGenerateRegions(AbstractImageContainer cont) {
        Scale scale;
        LocatedObjects annotations = this.m_Finder.findObjects(cont.getReport());
        if (this.isLoggingEnabled()) {
            this.getLogger().info("# objects: " + annotations.size());
        }
        if (this.m_ScaleFactor != 1.0) {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Scaling with factor: " + this.m_ScaleFactor);
            }
            scale = new Scale();
            scale.setScaleX(this.m_ScaleFactor);
            scale.setScaleY(this.m_ScaleFactor);
            scale.setRoundingType(RoundingType.ROUND);
            annotations = scale.filter(annotations);
        }
        int width = (int)((double)cont.getWidth() * this.m_ScaleFactor);
        int height = (int)((double)cont.getHeight() * this.m_ScaleFactor);
        int tileWidth = width / this.m_NumCols;
        int tileHeight = height / this.m_NumRows;
        int offsetX = tileWidth / 2;
        int offsetY = tileHeight / 2;
        IntArrayMatrixView matrix = new IntArrayMatrixView(width, height);
        if (this.isLoggingEnabled()) {
            this.getLogger().info("width=" + width + ", height=" + height + ", tileWidth=" + tileWidth + ", tileHeight=" + tileHeight + ", offsetX=" + offsetX + ", offsetY=" + offsetY);
        }
        for (LocatedObject obj : annotations) {
            this.fillInArea(matrix, obj, ANNOTATION);
        }
        LocatedObjects result = new LocatedObjects();
        int[] extX = new int[2];
        int[] extY = new int[2];
        int[] newX = new int[2];
        int[] newY = new int[2];
        for (int y = 0; y < this.m_NumRows && !this.isStopped(); ++y) {
            for (int x = 0; x < this.m_NumCols && !this.isStopped(); ++x) {
                LocatedObject region;
                int s = x * tileWidth + offsetX;
                int t = y * tileHeight + offsetY;
                if (matrix.get(s, t) != 0) continue;
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("row=" + y + ", col=" + x + ", y=" + t + ", x=" + s);
                }
                this.findExtent(matrix, s, t, true, extX);
                if (this.isValidExtent(extX)) {
                    extY[0] = -1;
                    extY[1] = -1;
                    int n = t - 1;
                    while (n >= 0) {
                        this.findExtent(matrix, s, n, true, newX);
                        if (!this.isValidExtent(newX) || newX[0] > extX[0] || newX[1] < extX[1]) break;
                        extY[0] = n--;
                    }
                    n = t + 1;
                    while (n < height) {
                        this.findExtent(matrix, s, n, true, newX);
                        if (!this.isValidExtent(newX) || newX[0] > extX[0] || newX[1] < extX[1]) break;
                        extY[1] = n++;
                    }
                    if (this.isValidExtent(extY)) {
                        region = new LocatedObject(null, extX[0], extY[0], extX[1] - extX[0] + 1, extY[1] - extY[0] + 1);
                        result.add(region);
                        if (this.isLoggingEnabled()) {
                            this.getLogger().info("horizontal block found: " + region);
                        }
                        this.fillInArea(matrix, region, NEGATIVE);
                    }
                }
                this.findExtent(matrix, s, t, false, extY);
                if (!this.isValidExtent(extY)) continue;
                extX[0] = -1;
                extX[1] = -1;
                int m = s - 1;
                while (m >= 0) {
                    this.findExtent(matrix, m, t, false, newY);
                    if (!this.isValidExtent(newY) || newY[0] > extY[0] || newY[1] < extY[1]) break;
                    extX[0] = m--;
                }
                m = s + 1;
                while (m < width) {
                    this.findExtent(matrix, m, t, false, newY);
                    if (!this.isValidExtent(newY) || newY[0] > extY[0] || newY[1] < extY[1]) break;
                    extX[1] = m++;
                }
                if (!this.isValidExtent(extX)) continue;
                region = new LocatedObject(null, extX[0], extY[0], extX[1] - extX[0] + 1, extY[1] - extY[0] + 1);
                result.add(region);
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("vertical block found: " + region);
                }
                this.fillInArea(matrix, region, NEGATIVE);
            }
        }
        if (!this.isStopped()) {
            if (this.m_ScaleFactor != 1.0) {
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("Reverse scaling of negative regions: " + this.m_ScaleFactor);
                }
                scale = new Scale();
                scale.setScaleX(1.0 / this.m_ScaleFactor);
                scale.setScaleY(1.0 / this.m_ScaleFactor);
                scale.setRoundingType(RoundingType.ROUND);
                result = scale.filter(result);
            }
        } else {
            result.clear();
        }
        return result;
    }
}

