/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.previewbrowser;

import adams.core.Utils;
import adams.data.image.ImageMetaDataHelper;
import adams.data.io.input.ApacheCommonsImageReader;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.SearchPanel;
import adams.gui.core.SpreadSheetTable;
import adams.gui.tools.previewbrowser.AbstractContentHandler;
import adams.gui.tools.previewbrowser.NoPreviewAvailablePanel;
import adams.gui.tools.previewbrowser.PreviewPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ApacheCommonsImageMetaDataHandler
extends AbstractContentHandler {
    private static final long serialVersionUID = -3962259305718630395L;

    public String globalInfo() {
        return "Displays meta-data for the following image types: " + Utils.arrayToString((Object)this.getExtensions());
    }

    public String[] getExtensions() {
        return new ApacheCommonsImageReader().getFormatExtensions();
    }

    protected PreviewPanel createPreview(File file) {
        try {
            JPanel panel = new JPanel(new BorderLayout(5, 5));
            SpreadSheet sheet = ImageMetaDataHelper.sanselan(file);
            SpreadSheetTable table = new SpreadSheetTable(sheet);
            panel.add((Component)new BaseScrollPane((Component)table));
            SearchPanel search = new SearchPanel(SearchPanel.LayoutType.HORIZONTAL, true);
            search.addSearchListener(e -> table.search(e.getParameters().getSearchString(), e.getParameters().isRegExp()));
            panel.add((Component)search, "South");
            return new PreviewPanel((JComponent)panel, (JComponent)table);
        }
        catch (Exception e2) {
            return new NoPreviewAvailablePanel();
        }
    }
}

