/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.previewbrowser;

import adams.core.Utils;
import adams.core.base.BaseRegExp;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.data.io.input.AbstractImageReader;
import adams.data.io.input.JAIImageReader;
import adams.data.io.input.ObjectLocationsSpreadSheetReader;
import adams.data.report.Report;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.gui.core.Fonts;
import adams.gui.tools.previewbrowser.AbstractContentHandler;
import adams.gui.tools.previewbrowser.PreviewPanel;
import adams.gui.visualization.core.ColorProvider;
import adams.gui.visualization.core.DefaultColorProvider;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.ObjectLocationsOverlayFromReport;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;

public class ObjectLocationsFromSpreadSheet
extends AbstractContentHandler {
    private static final long serialVersionUID = -3962259305718630395L;
    protected ObjectLocationsSpreadSheetReader m_Reader;
    protected Color m_Color;
    protected boolean m_UseColorsPerType;
    protected ColorProvider m_TypeColorProvider;
    protected String m_TypeSuffix;
    protected BaseRegExp m_TypeRegExp;
    protected String m_LabelFormat;
    protected Font m_LabelFont;

    public String globalInfo() {
        return "Displays the following image types with an overlay for the objects stored in the spreadsheet with the same name (using the spreadsheet reader's default extension) or with a '-rois' suffix to the name: " + Utils.arrayToString((Object)this.getExtensions());
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("reader", "reader", (Object)this.getDefaultReader());
        this.m_OptionManager.add("color", "color", (Object)Color.RED);
        this.m_OptionManager.add("use-colors-per-type", "useColorsPerType", (Object)true);
        this.m_OptionManager.add("type-color-provider", "typeColorProvider", (Object)new DefaultColorProvider());
        this.m_OptionManager.add("type-suffix", "typeSuffix", (Object)".type");
        this.m_OptionManager.add("type-regexp", "typeRegExp", (Object)new BaseRegExp(".*"));
        this.m_OptionManager.add("label-format", "labelFormat", (Object)"#. $");
        this.m_OptionManager.add("label-font", "labelFont", (Object)Fonts.getSansFont((int)14));
    }

    protected ObjectLocationsSpreadSheetReader getDefaultReader() {
        ObjectLocationsSpreadSheetReader result = new ObjectLocationsSpreadSheetReader();
        result.setColLeft(new SpreadSheetColumnIndex("x0"));
        result.setColTop(new SpreadSheetColumnIndex("y0"));
        result.setColRight(new SpreadSheetColumnIndex("x1"));
        result.setColBottom(new SpreadSheetColumnIndex("y1"));
        result.setColType(new SpreadSheetColumnIndex("label_str"));
        return result;
    }

    public void setReader(ObjectLocationsSpreadSheetReader value) {
        this.m_Reader = value;
        this.reset();
    }

    public ObjectLocationsSpreadSheetReader getReader() {
        return this.m_Reader;
    }

    public String readerTipText() {
        return "The reader setup to use for reading the object locations from the spreadsheet.";
    }

    public void setColor(Color value) {
        this.m_Color = value;
        this.reset();
    }

    public Color getColor() {
        return this.m_Color;
    }

    public String colorTipText() {
        return "The color to use for the objects.";
    }

    public void setUseColorsPerType(boolean value) {
        this.m_UseColorsPerType = value;
        this.reset();
    }

    public boolean getUseColorsPerType() {
        return this.m_UseColorsPerType;
    }

    public String useColorsPerTypeTipText() {
        return "If enabled, individual colors per type are used.";
    }

    public void setTypeColorProvider(ColorProvider value) {
        this.m_TypeColorProvider = value;
        this.reset();
    }

    public ColorProvider getTypeColorProvider() {
        return this.m_TypeColorProvider;
    }

    public String typeColorProviderTipText() {
        return "The color provider to use for the various types.";
    }

    public void setTypeSuffix(String value) {
        this.m_TypeSuffix = value;
        this.reset();
    }

    public String getTypeSuffix() {
        return this.m_TypeSuffix;
    }

    public String typeSuffixTipText() {
        return "The suffix of fields in the report to identify the type.";
    }

    public void setTypeRegExp(BaseRegExp value) {
        this.m_TypeRegExp = value;
        this.reset();
    }

    public BaseRegExp getTypeRegExp() {
        return this.m_TypeRegExp;
    }

    public String typeRegExpTipText() {
        return "The regular expression that the types must match in order to get drawn (eg only plotting a subset).";
    }

    public void setLabelFormat(String value) {
        this.m_LabelFormat = value;
        this.reset();
    }

    public String getLabelFormat() {
        return this.m_LabelFormat;
    }

    public String labelFormatTipText() {
        return "The label format string to use for the rectangles; '#' for index, '@' for type and '$' for short type (type suffix must be defined for '@' and '$'); for instance: '# @'.";
    }

    public void setLabelFont(Font value) {
        this.m_LabelFont = value;
        this.reset();
    }

    public Font getLabelFont() {
        return this.m_LabelFont;
    }

    public String labelFontTipText() {
        return "The font to use for the labels.";
    }

    public String[] getExtensions() {
        return new JAIImageReader().getFormatExtensions();
    }

    protected PreviewPanel createPreview(File file) {
        ImagePanel panel = new ImagePanel();
        ObjectLocationsOverlayFromReport overlay = null;
        Report report = null;
        File locFile = FileUtils.replaceExtension((File)file, (String)("." + this.m_Reader.getReader().getDefaultFormatExtension()));
        File locFile2 = FileUtils.replaceExtension((File)file, (String)("-rois." + this.m_Reader.getReader().getDefaultFormatExtension()));
        if (locFile2.exists() && locFile2.isFile()) {
            locFile = locFile2;
        }
        if (locFile.exists() && locFile.isFile()) {
            this.m_Reader.setInput(new PlaceholderFile(locFile));
            List reports = this.m_Reader.read();
            if (reports.size() > 0) {
                report = (Report)reports.get(0);
                overlay = new ObjectLocationsOverlayFromReport();
                overlay.setPrefix(this.m_Reader.getPrefix());
                overlay.setColor(this.m_Color);
                overlay.setUseColorsPerType(this.m_UseColorsPerType);
                overlay.setTypeColorProvider((ColorProvider)this.m_TypeColorProvider.shallowCopy());
                overlay.setTypeSuffix(this.m_TypeSuffix);
                overlay.setTypeRegExp((BaseRegExp)this.m_TypeRegExp.getClone());
                overlay.setLabelFormat(this.m_LabelFormat);
                overlay.setLabelFont(this.m_LabelFont);
            }
        }
        if (overlay != null) {
            panel.addImageOverlay(overlay);
            panel.setAdditionalProperties(report);
        }
        panel.load(file, (AbstractImageReader)new JAIImageReader(), -1.0);
        return new PreviewPanel((JComponent)panel, (JComponent)panel.getPaintPanel());
    }
}

