/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.previewbrowser;

import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.data.image.transformer.TrimapColorizer;
import adams.data.io.input.JAIImageReader;
import adams.data.io.input.VggXmlAnnotationReportReader;
import adams.data.report.Report;
import adams.gui.tools.previewbrowser.AbstractContentHandler;
import adams.gui.tools.previewbrowser.NoPreviewAvailablePanel;
import adams.gui.tools.previewbrowser.PreviewPanel;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.ObjectLocationsOverlayFromReport;
import java.awt.Color;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;

public class TrimapImageHandler
extends AbstractContentHandler {
    private static final long serialVersionUID = -3962259305718630395L;

    public String globalInfo() {
        return "Displays the following image types as trimaps: " + Utils.arrayToString((Object)this.getExtensions()) + "\nIf VGG XML annotation file with the same name exists, then an object overlay is added.";
    }

    public String[] getExtensions() {
        return new JAIImageReader().getFormatExtensions();
    }

    protected PreviewPanel createPreview(File file) {
        JAIImageReader reader = new JAIImageReader();
        BufferedImageContainer cont = (BufferedImageContainer)reader.read(new PlaceholderFile(file));
        if (cont == null) {
            return new NoPreviewAvailablePanel();
        }
        TrimapColorizer colorizer = new TrimapColorizer();
        cont = ((BufferedImageContainer[])colorizer.transform((AbstractImageContainer)cont))[0];
        ImagePanel panel = new ImagePanel();
        panel.setCurrentImage((AbstractImageContainer)cont);
        ObjectLocationsOverlayFromReport overlay = null;
        Report report = null;
        File reportFile = FileUtils.replaceExtension((File)file, (String)".xml");
        if (reportFile.exists() && reportFile.isFile()) {
            VggXmlAnnotationReportReader reportReader = new VggXmlAnnotationReportReader();
            reportReader.setInput(new PlaceholderFile(reportFile));
            List reports = reportReader.read();
            if (reports.size() > 0) {
                report = (Report)reports.get(0);
                overlay = new ObjectLocationsOverlayFromReport();
                overlay.setPrefix("Object.");
                overlay.setColor(Color.GREEN);
            }
        }
        if (overlay != null) {
            panel.addImageOverlay(overlay);
            panel.setAdditionalProperties(report);
        }
        return new PreviewPanel((JComponent)panel, (JComponent)panel.getPaintPanel());
    }
}

