/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image;

import adams.core.base.BaseRegExp;
import adams.core.base.BaseString;
import adams.gui.core.Fonts;
import adams.gui.core.GUIHelper;
import adams.gui.core.PopupMenuCustomizer;
import adams.gui.visualization.core.ColorProvider;
import adams.gui.visualization.core.DefaultColorProvider;
import adams.gui.visualization.image.AbstractImageOverlay;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.ReportObjectOverlay;
import adams.gui.visualization.image.TypeColorProvider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Polygon;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractObjectOverlayFromReport
extends AbstractImageOverlay
implements PopupMenuCustomizer<ImagePanel.PaintPanel>,
TypeColorProvider {
    private static final long serialVersionUID = 6356419097401574024L;
    public static final String PREFIX_DEFAULT = "Object.";
    protected ReportObjectOverlay m_Overlays;
    protected Set<ChangeListener> m_LocationsUpdatedListeners;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("prefix", "prefix", (Object)PREFIX_DEFAULT);
        this.m_OptionManager.add("color", "color", (Object)Color.RED);
        this.m_OptionManager.add("use-colors-per-type", "useColorsPerType", (Object)false);
        this.m_OptionManager.add("type-color-provider", "typeColorProvider", (Object)new DefaultColorProvider());
        this.m_OptionManager.add("type-suffix", "typeSuffix", (Object)".type");
        this.m_OptionManager.add("type-regexp", "typeRegExp", (Object)new BaseRegExp(".*"));
        this.m_OptionManager.add("label-format", "labelFormat", (Object)"#");
        this.m_OptionManager.add("label-font", "labelFont", (Object)Fonts.getSansFont((int)14));
        this.m_OptionManager.add("label-offset-x", "labelOffsetX", (Object)0);
        this.m_OptionManager.add("label-offset-y", "labelOffsetY", (Object)0);
        this.m_OptionManager.add("predefined-labels", "predefinedLabels", (Object)new BaseString[0]);
    }

    protected void initialize() {
        super.initialize();
        this.m_Overlays = new ReportObjectOverlay();
        this.m_LocationsUpdatedListeners = new HashSet<ChangeListener>();
    }

    public void setPrefix(String value) {
        this.m_Overlays.setPrefix(value);
        this.reset();
    }

    public String getPrefix() {
        return this.m_Overlays.getPrefix();
    }

    public String prefixTipText() {
        return this.m_Overlays.prefixTipText();
    }

    public void setColor(Color value) {
        this.m_Overlays.setColor(value);
        this.reset();
    }

    public Color getColor() {
        return this.m_Overlays.getColor();
    }

    public String colorTipText() {
        return this.m_Overlays.colorTipText();
    }

    public void setUseColorsPerType(boolean value) {
        this.m_Overlays.setUseColorsPerType(value);
        this.reset();
    }

    public boolean getUseColorsPerType() {
        return this.m_Overlays.getUseColorsPerType();
    }

    public String useColorsPerTypeTipText() {
        return this.m_Overlays.useColorsPerTypeTipText();
    }

    public void setTypeColorProvider(ColorProvider value) {
        this.m_Overlays.setTypeColorProvider(value);
        this.reset();
    }

    public ColorProvider getTypeColorProvider() {
        return this.m_Overlays.getTypeColorProvider();
    }

    public String typeColorProviderTipText() {
        return this.m_Overlays.typeColorProviderTipText();
    }

    public void setTypeSuffix(String value) {
        this.m_Overlays.setTypeSuffix(value);
        this.reset();
    }

    public String getTypeSuffix() {
        return this.m_Overlays.getTypeSuffix();
    }

    public String typeSuffixTipText() {
        return this.m_Overlays.typeSuffixTipText();
    }

    public void setTypeRegExp(BaseRegExp value) {
        this.m_Overlays.setTypeRegExp(value);
        this.reset();
    }

    public BaseRegExp getTypeRegExp() {
        return this.m_Overlays.getTypeRegExp();
    }

    public String typeRegExpTipText() {
        return this.m_Overlays.typeRegExpTipText();
    }

    public void setLabelFormat(String value) {
        this.m_Overlays.setLabelFormat(value);
        this.reset();
    }

    public String getLabelFormat() {
        return this.m_Overlays.getLabelFormat();
    }

    public String labelFormatTipText() {
        return this.m_Overlays.labelFormatTipText();
    }

    public void setLabelFont(Font value) {
        this.m_Overlays.setLabelFont(value);
        this.reset();
    }

    public Font getLabelFont() {
        return this.m_Overlays.getLabelFont();
    }

    public String labelFontTipText() {
        return this.m_Overlays.labelFontTipText();
    }

    public void setLabelOffsetX(int value) {
        this.m_Overlays.setLabelOffsetX(value);
        this.reset();
    }

    public int getLabelOffsetX() {
        return this.m_Overlays.getLabelOffsetX();
    }

    public String labelOffsetXTipText() {
        return this.m_Overlays.labelOffsetXTipText();
    }

    public void setLabelOffsetY(int value) {
        this.m_Overlays.setLabelOffsetY(value);
        this.reset();
    }

    public int getLabelOffsetY() {
        return this.m_Overlays.getLabelOffsetY();
    }

    public String labelOffsetYTipText() {
        return this.m_Overlays.labelOffsetYTipText();
    }

    public void setPredefinedLabels(BaseString[] value) {
        this.m_Overlays.setPredefinedLabels(value);
        this.reset();
    }

    public BaseString[] getPredefinedLabels() {
        return this.m_Overlays.getPredefinedLabels();
    }

    public String predefinedLabelsTipText() {
        return this.m_Overlays.predefinedLabelsTipText();
    }

    @Override
    public boolean hasTypeColor(String type) {
        return this.m_Overlays.hasTypeColor(type);
    }

    @Override
    public Color getTypeColor(String type) {
        return this.m_Overlays.getTypeColor(type);
    }

    @Override
    public void addLocationsUpdatedListeners(ChangeListener l) {
        this.m_LocationsUpdatedListeners.add(l);
    }

    @Override
    public void removeLocationsUpdatedListeners(ChangeListener l) {
        this.m_LocationsUpdatedListeners.remove(l);
    }

    protected void notifyLocationsUpdatedListeners() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : this.m_LocationsUpdatedListeners) {
            l.stateChanged(e);
        }
    }

    protected synchronized void doImageChanged(ImagePanel.PaintPanel panel) {
        this.m_Overlays.reset();
    }

    protected abstract void doPaintObjects(ImagePanel.PaintPanel var1, Graphics var2, List<Polygon> var3);

    protected synchronized void doPaintOverlay(ImagePanel.PaintPanel panel, Graphics g) {
        boolean updated = this.m_Overlays.determineLocations(panel.getOwner().getAdditionalProperties());
        if (this.m_Overlays.hasLocations()) {
            this.doPaintObjects(panel, g, this.m_Overlays.getLocations());
        }
        if (updated) {
            this.notifyLocationsUpdatedListeners();
        }
    }

    public void customizePopupMenu(ImagePanel.PaintPanel source, JPopupMenu menu) {
        if (!this.getTypeSuffix().isEmpty()) {
            JMenuItem menuitem = new JMenuItem("Displayed types", GUIHelper.getIcon((String)"objecttypes.gif"));
            menuitem.addActionListener(e -> {
                String type = GUIHelper.showInputDialog((Component)source, (String)"Regular expression for type", (String)this.getTypeRegExp().getValue());
                if (type == null) {
                    return;
                }
                if (!this.getTypeRegExp().isValid(type)) {
                    GUIHelper.showErrorMessage((Component)source, (String)("Invalid regular expression: " + type));
                    return;
                }
                this.setTypeRegExp(new BaseRegExp(type));
                source.update();
            });
            menu.add(menuitem);
        }
    }

    public void cleanUp() {
        if (this.m_LocationsUpdatedListeners != null) {
            this.m_LocationsUpdatedListeners.clear();
        }
        super.cleanUp();
    }
}

