/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image.selection;

import adams.core.Utils;
import adams.data.report.Report;
import adams.data.statistics.StatUtils;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.SelectionRectangle;
import adams.gui.visualization.image.interactionlogger.InteractionEvent;
import adams.gui.visualization.image.interactionlogger.InteractionLoggingSupporter;
import adams.gui.visualization.image.selection.AbstractSelectionRectangleBasedSelectionProcessor;
import adams.gui.visualization.image.selection.SelectionProcessorWithLabelSupport;
import java.awt.Color;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SelectObjects
extends AbstractSelectionRectangleBasedSelectionProcessor
implements SelectionProcessorWithLabelSupport,
InteractionLoggingSupporter {
    private static final long serialVersionUID = -5879410661391670242L;
    protected String m_Label;
    protected String m_LabelSuffix;

    public String globalInfo() {
        return "Allows the user to select objects in the image.\nThe locations get stored in the attached report.\nIf the <ctrl> key is pressed while drawing a selection rectangle, all enclosed locations get removed.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("label", "label", (Object)this.getDefaultLabel());
        this.m_OptionManager.add("label-suffix", "labelSuffix", (Object)this.getDefaultLabelSuffix());
    }

    protected String getDefaultLabel() {
        return "";
    }

    @Override
    public void setLabel(String value) {
        this.m_Label = value;
        this.reset();
    }

    @Override
    public String getLabel() {
        return this.m_Label;
    }

    @Override
    public String labelTipText() {
        return "The label to use for the objects, not set if empty.";
    }

    protected String getDefaultLabelSuffix() {
        return ".type";
    }

    @Override
    public void setLabelSuffix(String value) {
        this.m_LabelSuffix = value;
        this.reset();
    }

    @Override
    public String getLabelSuffix() {
        return this.m_LabelSuffix;
    }

    @Override
    public String labelSuffixTipText() {
        return "The suffix to use for storing the label in the report.";
    }

    @Override
    protected Color getDefaultColor() {
        return Color.RED;
    }

    protected void logAdd(ImagePanel panel, int x, int y, int w, int h, int[] poly_x, int[] poly_y) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("x", x);
        data.put("y", y);
        data.put("width", w);
        data.put("height", h);
        if (poly_x != null) {
            data.put("poly_x", poly_x);
        }
        if (poly_y != null) {
            data.put("poly_y", poly_y);
        }
        if (!this.m_Label.isEmpty()) {
            data.put("label", this.m_Label);
        }
        InteractionEvent e = new InteractionEvent(panel, new Date(), "add", data);
        panel.addInteractionLog(e);
    }

    protected void logRemove(ImagePanel panel, int x, int y, int w, int h, List<Map<String, Object>> removed) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("x", x);
        data.put("y", y);
        data.put("width", w);
        data.put("height", h);
        data.put("removed", removed);
        InteractionEvent e = new InteractionEvent(panel, new Date(), "remove", data);
        panel.addInteractionLog(e);
    }

    protected void doProcessSelection(ImagePanel panel, Point topLeft, Point bottomRight, List<Point> trace, int modifiersEx) {
        int h;
        int w;
        int y;
        int x;
        Report report = panel.getAdditionalProperties().getClone();
        if (this.m_Locations == null) {
            this.m_Locations = this.getLocations(report);
        }
        Polygon poly = null;
        int[] poly_x = null;
        int[] poly_y = null;
        if (trace.size() > 0) {
            poly = panel.traceToPolygon(trace);
            Rectangle bounds = poly.getBounds();
            x = (int)bounds.getX();
            y = (int)bounds.getY();
            w = (int)bounds.getWidth();
            h = (int)bounds.getHeight();
        } else {
            x = panel.mouseToPixelLocation((Point)topLeft).x;
            y = panel.mouseToPixelLocation((Point)topLeft).y;
            w = panel.mouseToPixelLocation((Point)bottomRight).x - panel.mouseToPixelLocation((Point)topLeft).x + 1;
            h = panel.mouseToPixelLocation((Point)bottomRight).y - panel.mouseToPixelLocation((Point)topLeft).y + 1;
        }
        SelectionRectangle rect = new SelectionRectangle(x, y, w, h, -1);
        ArrayList<SelectionRectangle> queue = new ArrayList<SelectionRectangle>();
        ArrayList<Map<String, Object>> objects = new ArrayList<Map<String, Object>>();
        boolean modified = false;
        if ((modifiersEx & 0x80) != 0) {
            for (SelectionRectangle r : this.m_Locations) {
                if (!rect.contains(r)) continue;
                objects.add(this.valuesForIndex(report, r.getIndex()));
                if (!this.removeIndex(report, r.getIndex())) continue;
                modified = true;
                queue.add(r);
            }
            this.m_Locations.removeAll(queue);
            this.logRemove(panel, x, y, w, h, objects);
        } else if (!this.m_Locations.contains(rect)) {
            modified = true;
            int lastIndex = this.findLastIndex(report);
            String current = this.m_Prefix + Utils.padLeft((String)("" + (lastIndex + 1)), (char)'0', (int)this.m_NumDigits);
            report.setNumericValue(current + ".x", (double)x);
            report.setNumericValue(current + ".y", (double)y);
            report.setNumericValue(current + ".width", (double)w);
            report.setNumericValue(current + ".height", (double)h);
            if (poly != null) {
                poly_x = new int[trace.size()];
                poly_y = new int[trace.size()];
                for (int i = 0; i < trace.size(); ++i) {
                    poly_x[i] = (int)panel.mouseToPixelLocation(trace.get(i)).getX();
                    poly_y[i] = (int)panel.mouseToPixelLocation(trace.get(i)).getY();
                }
                report.setStringValue(current + ".poly_x", Utils.flatten((Object[])StatUtils.toNumberArray((int[])poly_x), (String)","));
                report.setStringValue(current + ".poly_y", Utils.flatten((Object[])StatUtils.toNumberArray((int[])poly_y), (String)","));
            }
            if (!this.m_Label.isEmpty()) {
                report.setStringValue(current + this.m_LabelSuffix, this.m_Label);
            }
            this.m_Locations.add(rect);
            this.logAdd(panel, x, y, w, h, poly_x, poly_y);
        }
        if (modified) {
            panel.setAdditionalProperties(report);
        }
    }

    public boolean supportsInteractionLogging() {
        return true;
    }
}

