/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.base.BaseString;
import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.data.conversion.Conversion;
import adams.data.conversion.StringToString;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.control.flowrestart.AbstractFlowRestartManager;
import adams.flow.control.flowrestart.NullManager;
import adams.flow.core.AbstractActor;
import adams.flow.core.Actor;
import adams.flow.execution.FlowExecutionListener;
import adams.flow.execution.NullListener;
import adams.flow.sink.DumpFile;
import adams.flow.source.StringConstants;
import adams.flow.transformer.ColorProvider;
import adams.gui.visualization.core.DefaultColorProvider;
import adams.test.AdamsTestCase;
import adams.test.TmpFile;
import java.io.File;
import java.util.ArrayList;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;

public class ColorProviderTest
extends AbstractFlowTest {
    public ColorProviderTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public void testRegression() {
        this.performRegressionTest((File[])new TmpFile[]{new TmpFile("dumpfile.txt")});
    }

    public static Test suite() {
        return new TestSuite(ColorProviderTest.class);
    }

    public AbstractActor getActor() {
        Flow flow = new Flow();
        try {
            ArrayList<Object> actors = new ArrayList<Object>();
            StringConstants stringconstants = new StringConstants();
            AbstractArgumentOption argOption = (AbstractArgumentOption)stringconstants.getOptionManager().findByProperty("strings");
            ArrayList<BaseString> strings = new ArrayList<BaseString>();
            strings.add((BaseString)argOption.valueOf("1"));
            strings.add((BaseString)argOption.valueOf("2"));
            strings.add((BaseString)argOption.valueOf("3"));
            stringconstants.setStrings(strings.toArray(new BaseString[0]));
            StringToString stringtostring = new StringToString();
            stringconstants.setConversion((Conversion)stringtostring);
            actors.add(stringconstants);
            ColorProvider colorprovider = new ColorProvider();
            DefaultColorProvider defaultcolorprovider = new DefaultColorProvider();
            colorprovider.setProvider((adams.gui.visualization.core.ColorProvider)defaultcolorprovider);
            actors.add(colorprovider);
            DumpFile dumpfile = new DumpFile();
            argOption = (AbstractArgumentOption)dumpfile.getOptionManager().findByProperty("outputFile");
            dumpfile.setOutputFile((PlaceholderFile)argOption.valueOf("${TMP}/dumpfile.txt"));
            dumpfile.setAppend(true);
            actors.add(dumpfile);
            flow.setActors(actors.toArray(new Actor[0]));
            NullListener nulllistener = new NullListener();
            flow.setFlowExecutionListener((FlowExecutionListener)nulllistener);
            NullManager nullmanager = new NullManager();
            flow.setFlowRestartManager((AbstractFlowRestartManager)nullmanager);
        }
        catch (Exception e) {
            Assert.fail((String)("Failed to set up actor: " + e));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        AdamsTestCase.runTest((Test)ColorProviderTest.suite());
    }
}

