/*
 * Decompiled with CFR 0.152.
 */
package adams.core.base;

import adams.core.base.AbstractBaseString;
import java.awt.Rectangle;
import java.awt.geom.Point2D;

public class BaseRectangle
extends AbstractBaseString {
    private static final long serialVersionUID = -5853830144343397434L;

    public BaseRectangle() {
        this("0 0 1 1", false);
    }

    public BaseRectangle(String s) {
        this(s, false);
    }

    public BaseRectangle(String s, boolean isXY) {
        super(isXY ? BaseRectangle.fromXY(s) : s);
    }

    public BaseRectangle(Rectangle location) {
        this(location.x, location.y, location.width, location.height, false);
    }

    public BaseRectangle(int x, int y, int w, int h) {
        this(x, y, w, h, false);
    }

    public BaseRectangle(int x, int y, int w_or_x, int h_or_y, boolean isXY) {
        this(x + " " + y + " " + (isXY ? w_or_x - x + 1 : w_or_x) + " " + (isXY ? h_or_y - y + 1 : h_or_y));
    }

    public BaseRectangle(double x, double y, double w, double h) {
        this(x, y, w, h, false);
    }

    public BaseRectangle(double x, double y, double w_or_x, double h_or_y, boolean isXY) {
        this(x + " " + y + " " + (isXY ? w_or_x - x + 1.0 : w_or_x) + " " + (isXY ? h_or_y - y + 1.0 : h_or_y));
    }

    public boolean isValid(String value) {
        return BaseRectangle.isValidFormat(value);
    }

    public double[] doubleValue() {
        String[] parts = this.getValue().split(" ");
        double[] result = new double[4];
        if (parts.length != 4) {
            return result;
        }
        for (int i = 0; i < parts.length; ++i) {
            result[i] = Double.parseDouble(parts[i]);
        }
        return result;
    }

    public int[] intValue() {
        String[] parts = this.getValue().split(" ");
        int[] result = new int[4];
        if (parts.length != 4) {
            return result;
        }
        for (int i = 0; i < parts.length; ++i) {
            result[i] = (int)Double.parseDouble(parts[i]);
        }
        return result;
    }

    public Rectangle rectangleValue() {
        int[] parts = this.intValue();
        Rectangle result = new Rectangle(parts[0], parts[1], parts[2], parts[3]);
        return result;
    }

    public String xyValue() {
        Rectangle rect = this.rectangleValue();
        boolean allInt = rect.getX() == (double)((int)rect.getX()) && rect.getY() == (double)((int)rect.getY()) && rect.getWidth() == (double)((int)rect.getWidth()) && rect.getHeight() == (double)((int)rect.getHeight());
        String result = allInt ? (int)rect.getX() + " " + (int)rect.getY() + " " + (int)(rect.getX() + rect.getWidth() - 1.0) + " " + (int)(rect.getY() + rect.getHeight() - 1.0) : rect.getX() + " " + rect.getY() + " " + (rect.getX() + rect.getWidth() - 1.0) + " " + (rect.getY() + rect.getHeight() - 1.0);
        return result;
    }

    public Point2D centerValue() {
        Rectangle rect = this.rectangleValue();
        return new Point2D.Double(rect.getCenterX(), rect.getCenterY());
    }

    public String getTipText() {
        return "Rectangle location string.";
    }

    public static boolean isValidFormat(String value) {
        String[] parts = (value = value.replaceAll("  ", " ")).split(" ");
        if (parts.length != 4) {
            return false;
        }
        try {
            for (String part : parts) {
                Double.parseDouble(part);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static String fromXY(String x0y0x1y1) {
        String[] parts = (x0y0x1y1 = x0y0x1y1.replaceAll("  ", " ")).split(" ");
        if (parts.length != 4) {
            throw new IllegalArgumentException("Expected four numbers in string: " + x0y0x1y1);
        }
        double[] values = new double[4];
        for (int i = 0; i < parts.length; ++i) {
            values[i] = Double.parseDouble(parts[i]);
        }
        values[2] = values[2] - values[0] + 1.0;
        values[3] = values[3] - values[1] + 1.0;
        return values[0] + " " + values[1] + " " + values[2] + " " + values[3];
    }
}

