/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io.fileuse;

import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.io.fileuse.AbstractFileUseCheck;
import java.io.Closeable;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.logging.Level;

public class PngIsComplete
extends AbstractFileUseCheck {
    private static final long serialVersionUID = -3766862011655514895L;

    public String globalInfo() {
        return "Checks whether the PNG file ends with bytes IEND (EOF for PNGs).\nSee also:\nhttps://en.wikipedia.org/wiki/Portable_Network_Graphics#Critical_chunks\nhttp://www.libpng.org/pub/png/spec/1.2/PNG-Structure.html#Chunk-layout\nhttp://www.libpng.org/pub/png/spec/1.2/PNG-Chunks.html#C.IEND";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInUse(File file) {
        boolean result;
        RandomAccessFile raf;
        block7: {
            raf = null;
            try {
                byte[] buffer = new byte[8];
                raf = new RandomAccessFile(file.getAbsolutePath(), "r");
                if (file.length() > 8L) {
                    raf.seek(file.length() - 8L);
                    raf.read(buffer, 0, 8);
                    boolean bl = result = buffer[0] != 73 || buffer[1] != 69 || buffer[2] != 78 || buffer[3] != 68;
                    if (this.isLoggingEnabled()) {
                        this.getLogger().info("First four bytes of the last eight byte block: " + Utils.toHex((byte)buffer[0]) + Utils.toHex((byte)buffer[1]) + Utils.toHex((byte)buffer[2]) + Utils.toHex((byte)buffer[3]) + " -> " + result);
                    }
                    break block7;
                }
                result = true;
            }
            catch (Exception e) {
                try {
                    if (this.isLoggingEnabled()) {
                        this.getLogger().log(Level.SEVERE, "Failed to extract bytes from: " + file, (Throwable)e);
                    }
                    result = true;
                }
                catch (Throwable throwable) {
                    FileUtils.closeQuietly(raf);
                    throw throwable;
                }
                FileUtils.closeQuietly((Closeable)raf);
            }
        }
        FileUtils.closeQuietly((Closeable)raf);
        return result;
    }
}

