/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.data.conversion.AbstractConversion;
import adams.data.image.AbstractImageContainer;
import adams.data.objectfinder.AllFinder;
import adams.data.objectfinder.ObjectFinder;
import adams.data.report.Report;
import adams.flow.container.ImageSegmentationContainer;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.HashSet;

public class ObjectAnnotationsToImageSegmentationLayers
extends AbstractConversion {
    private static final long serialVersionUID = -461975749250150031L;
    protected ObjectFinder m_Finder;
    protected String m_TypeSuffix;

    public String globalInfo() {
        return "Converts the annotations to image segmentation layers.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("finder", "finder", (Object)new AllFinder());
        this.m_OptionManager.add("type-suffix", "typeSuffix", (Object)".type");
    }

    public void setFinder(ObjectFinder value) {
        this.m_Finder = value;
        this.reset();
    }

    public ObjectFinder getFinder() {
        return this.m_Finder;
    }

    public String finderTipText() {
        return "The object finder to use.";
    }

    public void setTypeSuffix(String value) {
        this.m_TypeSuffix = value;
        this.reset();
    }

    public String getTypeSuffix() {
        return this.m_TypeSuffix;
    }

    public String typeSuffixTipText() {
        return "The suffix of fields in the report to identify the type.";
    }

    public Class accepts() {
        return AbstractImageContainer.class;
    }

    public Class generates() {
        return ImageSegmentationContainer.class;
    }

    protected Object doConvert() throws Exception {
        BufferedImage image;
        String key;
        AbstractImageContainer cont = (AbstractImageContainer)this.m_Input;
        Report report = cont.getReport();
        int width = cont.getWidth();
        int height = cont.getHeight();
        LocatedObjects objects = this.m_Finder.findObjects(report);
        String name = "unknown";
        if (report.hasValue("File")) {
            name = new PlaceholderFile(report.getStringValue("File")).getName();
        } else if (report.hasValue("Name")) {
            name = new PlaceholderFile(report.getStringValue("Name")).getName();
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Name: " + name);
        }
        if ((key = this.m_TypeSuffix).startsWith(".")) {
            key = key.substring(1);
        }
        HashSet<String> types = new HashSet<String>();
        for (LocatedObject obj : objects) {
            if (!obj.getMetaData().containsKey(key)) continue;
            types.add("" + obj.getMetaData().get(key));
        }
        if (types.size() == 0) {
            throw new IllegalStateException("No types identified using suffix: " + this.m_TypeSuffix);
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Types: " + Utils.flatten((Object[])types.toArray(), (String)", "));
        }
        HashMap<String, BufferedImage> layers = new HashMap<String, BufferedImage>();
        for (String type : types) {
            image = new BufferedImage(width, height, 1);
            layers.put(type, image);
        }
        for (String type : types) {
            image = (BufferedImage)layers.get(type);
            Graphics2D g2d = image.createGraphics();
            g2d.setColor(Color.BLACK);
            g2d.fillRect(0, 0, width, height);
            g2d.setColor(Color.WHITE);
            for (LocatedObject obj : objects) {
                String value;
                if (!obj.getMetaData().containsKey(key) || !(value = "" + obj.getMetaData().get(key)).equals(type)) continue;
                if (obj.hasPolygon()) {
                    g2d.fillPolygon(obj.getPolygon());
                    continue;
                }
                g2d.fillRect(obj.getX(), obj.getY(), obj.getWidth(), obj.getHeight());
            }
            g2d.dispose();
        }
        ImageSegmentationContainer result = new ImageSegmentationContainer(name, cont.toBufferedImage(), layers);
        return result;
    }
}

