/*
 * Decompiled with CFR 0.152.
 */
package adams.data.exif.commons;

import adams.core.ConfigurableEnumeration;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.imaging.formats.tiff.constants.ExifTagConstants;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;

public class ExifTagEnum
extends ConfigurableEnumeration<Item> {
    private static final long serialVersionUID = -4797024800799130165L;
    protected static ExifTagEnum m_Singleton;

    protected Item[] initialize() {
        ArrayList<Item> result = new ArrayList<Item>();
        HashSet<String> unique = new HashSet<String>();
        for (TagInfo tagInfo : ExifTagConstants.ALL_EXIF_TAGS) {
            if (unique.contains("" + tagInfo.tag)) continue;
            result.add(new Item(this, tagInfo));
            unique.add("" + tagInfo.tag);
        }
        return result.toArray(new Item[0]);
    }

    public Item newItem(String id, String display) {
        for (TagInfo tagInfo : ExifTagConstants.ALL_EXIF_TAGS) {
            if (!tagInfo.name.equals(id)) continue;
            return new Item(this, tagInfo);
        }
        return null;
    }

    public static synchronized ExifTagEnum getSingleton() {
        if (m_Singleton == null) {
            m_Singleton = new ExifTagEnum();
        }
        return m_Singleton;
    }

    public class Item
    extends ConfigurableEnumeration.AbstractItem {
        private static final long serialVersionUID = 436668216654476094L;
        protected transient TagInfo m_TagInfo;

        public Item(ExifTagEnum enumeration, TagInfo tagInfo) {
            super((ConfigurableEnumeration)enumeration, "" + tagInfo.tag, tagInfo.getDescription());
            this.m_TagInfo = tagInfo;
        }

        public TagInfo getTagInfo() {
            if (this.m_TagInfo == null) {
                for (TagInfo tagInfo : ExifTagConstants.ALL_EXIF_TAGS) {
                    if (!tagInfo.name.equals(this.getID())) continue;
                    this.m_TagInfo = tagInfo;
                    break;
                }
            }
            return this.m_TagInfo;
        }
    }
}

