/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image;

import adams.core.CleanUpHandler;
import adams.core.ShallowCopySupporter;
import adams.core.base.BaseString;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.data.featureconverter.AbstractFeatureConverter;
import adams.data.featureconverter.HeaderDefinition;
import adams.data.featureconverter.SpreadSheet;
import adams.data.image.AbstractImageContainer;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;
import java.lang.reflect.Array;
import java.util.List;
import java.util.logging.Level;

public abstract class AbstractImageFeatureGenerator<T extends AbstractImageContainer>
extends AbstractOptionHandler
implements Comparable,
CleanUpHandler,
ShallowCopySupporter<AbstractImageFeatureGenerator> {
    private static final long serialVersionUID = 4566948525813804085L;
    protected AbstractFeatureConverter m_Converter;
    protected String m_Prefix;
    protected Field[] m_Fields;
    protected BaseString[] m_Notes;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("converter", "converter", (Object)new SpreadSheet());
        this.m_OptionManager.add("prefix", "prefix", (Object)"");
        this.m_OptionManager.add("field", "fields", (Object)new Field[0]);
        this.m_OptionManager.add("notes", "notes", (Object)new BaseString[0]);
    }

    protected void reset() {
        super.reset();
        if (this.m_Converter != null) {
            this.m_Converter.reset();
        }
    }

    public void setConverter(AbstractFeatureConverter value) {
        this.m_Converter = value;
        this.reset();
    }

    public AbstractFeatureConverter getConverter() {
        return this.m_Converter;
    }

    public String converterTipText() {
        return "The feature converter to use to produce the output data.";
    }

    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The (optional) prefix to use for the feature names.";
    }

    public void setFields(Field[] value) {
        this.m_Fields = value;
        this.reset();
    }

    public Field[] getFields() {
        return this.m_Fields;
    }

    public String fieldsTipText() {
        return "The fields to add to the output.";
    }

    public void setNotes(BaseString[] value) {
        this.m_Notes = value;
        this.reset();
    }

    public BaseString[] getNotes() {
        return this.m_Notes;
    }

    public String notesTipText() {
        return "The notes to add as attributes to the generated data, eg 'PROCESS INFORMATION'.";
    }

    public Class getDatasetFormat() {
        return this.m_Converter.getDatasetFormat();
    }

    public Class getRowFormat() {
        return this.m_Converter.getRowFormat();
    }

    protected void checkData(T img) {
        if (img == null) {
            throw new IllegalStateException("No image provided!");
        }
    }

    public abstract HeaderDefinition createHeader(T var1);

    public HeaderDefinition postProcessHeader(HeaderDefinition header) {
        int i;
        HeaderDefinition result = header;
        for (i = 0; i < this.m_Notes.length; ++i) {
            header.add(this.m_Notes[i].getValue(), DataType.STRING);
        }
        for (i = 0; i < this.m_Fields.length; ++i) {
            header.add(this.m_Fields[i].getName(), this.m_Fields[i].getDataType());
        }
        if (!this.m_Prefix.isEmpty()) {
            for (i = 0; i < header.size(); ++i) {
                header.rename(i, this.m_Prefix + header.getName(i));
            }
        }
        return result;
    }

    public abstract List<Object>[] generateRows(T var1);

    public List<Object> postProcessRow(T img, List<Object> data) {
        int i;
        for (i = 0; i < this.m_Notes.length; ++i) {
            String valueStr = img.getNotes().getPrefixSubset(this.m_Notes[i].getValue()).toString();
            data.add(valueStr);
        }
        Report report = img.getReport();
        for (i = 0; i < this.m_Fields.length; ++i) {
            if (report.hasValue((AbstractField)this.m_Fields[i])) {
                try {
                    switch (this.m_Fields[i].getDataType()) {
                        case NUMERIC: {
                            data.add(report.getDoubleValue((AbstractField)this.m_Fields[i]));
                            break;
                        }
                        case BOOLEAN: {
                            data.add(report.getBooleanValue((AbstractField)this.m_Fields[i]));
                            break;
                        }
                        default: {
                            data.add(report.getStringValue((AbstractField)this.m_Fields[i]));
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    this.getLogger().log(Level.SEVERE, "Failed to retrieve field '" + this.m_Fields[i] + "'!", (Throwable)e);
                    data.add(null);
                }
                continue;
            }
            data.add(null);
        }
        return data;
    }

    public List<Object>[] postProcessRows(T img, List<Object>[] data) {
        List[] result = new List[data.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.postProcessRow(img, data[i]);
        }
        return result;
    }

    public Object[] generate(T img) {
        this.checkData(img);
        if (!this.m_Converter.isInitialized()) {
            HeaderDefinition header = this.createHeader(img);
            if (header == null) {
                throw new IllegalStateException("Failed to create header!");
            }
            header = this.postProcessHeader(header);
            this.m_Converter.generateHeader(header);
        }
        List<Object>[] data = this.generateRows(img);
        data = this.postProcessRows(img, data);
        Object[] result = (Object[])Array.newInstance(this.m_Converter.getRowFormat(), data.length);
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.m_Converter.generateRow(data[i]);
        }
        return result;
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        return OptionUtils.getCommandLine((Object)this).compareTo(OptionUtils.getCommandLine((Object)o));
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    public AbstractImageFeatureGenerator shallowCopy() {
        return this.shallowCopy(false);
    }

    public AbstractImageFeatureGenerator shallowCopy(boolean expand) {
        return (AbstractImageFeatureGenerator)OptionUtils.shallowCopy((OptionHandler)this, (boolean)expand);
    }

    public void cleanUp() {
        this.reset();
    }

    public void destroy() {
        this.cleanUp();
        super.destroy();
    }
}

