/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.features;

import adams.data.featureconverter.HeaderDefinition;
import adams.data.image.BufferedImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.image.features.AbstractBufferedImageFeatureGenerator;
import adams.data.report.DataType;
import adams.gui.core.ColorHelper;
import gnu.trove.map.hash.TIntIntHashMap;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public class ColorCounts
extends AbstractBufferedImageFeatureGenerator {
    private static final long serialVersionUID = -8349656592325229512L;

    public String globalInfo() {
        return "Counts the occurrences of colors in the image (alpha channel gets ignored).";
    }

    @Override
    public HeaderDefinition createHeader(BufferedImageContainer img) {
        HeaderDefinition result = new HeaderDefinition();
        result.add("Color", DataType.STRING);
        result.add("Count", DataType.NUMERIC);
        return result;
    }

    @Override
    public List<Object>[] generateRows(BufferedImageContainer img) {
        int i;
        BufferedImage image = BufferedImageHelper.convert((BufferedImage)((BufferedImage)img.getImage()), (int)6);
        int[] pixels = BufferedImageHelper.getPixels((BufferedImage)image);
        TIntIntHashMap colors = new TIntIntHashMap();
        for (i = 0; i < pixels.length; ++i) {
            int color = pixels[i] & 0xFFFFFF;
            if (!colors.containsKey(color)) {
                colors.put(color, 0);
            }
            colors.put(color, colors.get(color) + 1);
        }
        List[] result = new List[colors.size()];
        int[] keys = colors.keys();
        for (i = 0; i < keys.length; ++i) {
            result[i] = new ArrayList();
            result[i].add(ColorHelper.toHex((Color)new Color(keys[i])));
            result[i].add(colors.get(keys[i]));
        }
        return result;
    }
}

