/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.imagesegmentationcontainer;

import adams.data.image.BufferedImageHelper;
import adams.data.image.imagesegmentationcontainer.AbstractImageSegmentationContainerOperation;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.container.ImageSegmentationContainer;
import com.github.fracpete.javautils.struct.Struct2;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class EvaluatePrediction
extends AbstractImageSegmentationContainerOperation {
    private static final long serialVersionUID = 5451678654384977453L;
    public static final String KEY_ANNOTATION = "annotation";
    public static final String KEY_MISSED = "missed";
    public static final String KEY_OVERLAP = "overlap";
    public static final String KEY_ADDITIONAL = "additional";
    protected boolean m_AddMisclassification;

    public String globalInfo() {
        return "Evaluates a prediction (first container) against the annotation (second container) and outputs a spreadsheet with the results.\nFor calculating the misclassified percentage, the total pixel count of the other label is used as denominator.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("add-misclassification", "addMisclassification", (Object)false);
    }

    public void setAddMisclassification(boolean value) {
        this.m_AddMisclassification = value;
        this.reset();
    }

    public boolean getAddMisclassification() {
        return this.m_AddMisclassification;
    }

    public String addMisclassificationTipText() {
        return "If enabled, additional columns with misclassification information are added.";
    }

    @Override
    public int minNumContainersRequired() {
        return 2;
    }

    @Override
    public int maxNumContainersRequired() {
        return 2;
    }

    @Override
    public Class generates() {
        return SpreadSheet.class;
    }

    protected Map<String, Integer> compare(int[] predPixels, int[] annoPixels) {
        int black = Color.BLACK.getRGB();
        if (predPixels == null) {
            predPixels = new int[annoPixels.length];
            Arrays.fill(predPixels, black);
        }
        int annotationCount = 0;
        int additionalCount = 0;
        int missedCount = 0;
        int overlapCount = 0;
        for (int i = 0; i < predPixels.length; ++i) {
            if (annoPixels[i] != black) {
                ++annotationCount;
            }
            if (predPixels[i] == annoPixels[i]) {
                if (predPixels[i] == black) continue;
                ++overlapCount;
                continue;
            }
            if (predPixels[i] != black) {
                ++additionalCount;
                continue;
            }
            if (predPixels[i] != black) continue;
            ++missedCount;
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        result.put(KEY_ANNOTATION, annotationCount);
        result.put(KEY_MISSED, missedCount);
        result.put(KEY_ADDITIONAL, additionalCount);
        result.put(KEY_OVERLAP, overlapCount);
        return result;
    }

    protected Struct2<Integer, Double> calcMisclassified(int[] predPixels, int[] annoOtherPixels) {
        Struct2 result = new Struct2((Object)0, (Object)0.0);
        int black = Color.BLACK.getRGB();
        if (predPixels == null) {
            predPixels = new int[annoOtherPixels.length];
            Arrays.fill(predPixels, black);
        }
        int annoTotal = 0;
        for (int i = 0; i < predPixels.length; ++i) {
            if (annoOtherPixels[i] != black && predPixels[i] != black) {
                Struct2 struct2 = result;
                Integer n = (Integer)struct2.value1;
                struct2.value1 = (Integer)struct2.value1 + 1;
                Integer n2 = struct2.value1;
            }
            if (annoOtherPixels[i] == black) continue;
            ++annoTotal;
        }
        result.value2 = (double)((Integer)result.value1).intValue() / (double)annoTotal;
        return result;
    }

    @Override
    protected Object doProcess(ImageSegmentationContainer[] containers) {
        ImageSegmentationContainer predCont = containers[0];
        Map predLayers = (Map)predCont.getValue("layers");
        ImageSegmentationContainer annoCont = containers[1];
        Map annoLayers = (Map)annoCont.getValue("layers");
        ArrayList labels = new ArrayList(annoLayers.keySet());
        Collections.sort(labels);
        HashMap<String, int[]> predPixels = new HashMap<String, int[]>();
        HashMap<String, int[]> annoPixels = new HashMap<String, int[]>();
        for (String label : labels) {
            if (predLayers.containsKey(label)) {
                predPixels.put(label, BufferedImageHelper.getPixels((BufferedImage)((BufferedImage)predLayers.get(label))));
            }
            if (!annoLayers.containsKey(label)) continue;
            annoPixels.put(label, BufferedImageHelper.getPixels((BufferedImage)((BufferedImage)annoLayers.get(label))));
        }
        DefaultSpreadSheet result = new DefaultSpreadSheet();
        result.addComment("Name: " + predCont.getValue("name"));
        HeaderRow row = result.getHeaderRow();
        row.addCell("L").setContentAsString("Layer");
        row.addCell("O").setContentAsString("Overlap");
        row.addCell("OP").setContentAsString("Overlap (perc)");
        row.addCell("M").setContentAsString("Missed");
        row.addCell("MP").setContentAsString("Missed (perc)");
        row.addCell("A").setContentAsString("Additional");
        row.addCell("AP").setContentAsString("Additional (perc)");
        if (this.m_AddMisclassification) {
            for (String label : labels) {
                row.addCell("ACT-" + label).setContentAsString("Actual layer " + label);
                row.addCell("ACTP-" + label).setContentAsString("Actual layer " + label + " (perc)");
            }
        }
        for (String label : labels) {
            row = result.addRow();
            row.getCell("L").setContentAsString(label);
            Map<String, Integer> stats = this.compare((int[])predPixels.get(label), (int[])annoPixels.get(label));
            int total = stats.get(KEY_ANNOTATION);
            row.getCell("O").setContent(stats.get(KEY_OVERLAP));
            row.getCell("OP").setContent(Double.valueOf((double)stats.get(KEY_OVERLAP).intValue() / (double)total));
            row.getCell("M").setContent(stats.get(KEY_MISSED));
            row.getCell("MP").setContent(Double.valueOf((double)stats.get(KEY_MISSED).intValue() / (double)total));
            row.getCell("A").setContent(stats.get(KEY_ADDITIONAL));
            row.getCell("AP").setContent(Double.valueOf((double)stats.get(KEY_ADDITIONAL).intValue() / (double)total));
            if (!this.m_AddMisclassification) continue;
            for (String other : labels) {
                if (other.equals(label)) continue;
                Struct2<Integer, Double> miscl = this.calcMisclassified((int[])predPixels.get(label), (int[])annoPixels.get(other));
                row.getCell("ACT-" + other).setContent((Integer)miscl.value1);
                row.getCell("ACTP-" + other).setContent((Double)miscl.value2);
            }
        }
        return result;
    }
}

