/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.image.BufferedImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.image.transformer.AbstractBufferedImageTransformer;
import java.awt.image.BufferedImage;

public class DownSample
extends AbstractBufferedImageTransformer {
    private static final long serialVersionUID = 8400999643470579756L;
    protected int m_NthPixel;

    public String globalInfo() {
        return "Generates a smaller image by taken every nth pixel (on the x and y axis).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("nth", "nthPixel", (Object)1, (Number)1, null);
    }

    public void setNthPixel(int value) {
        if (this.getOptionManager().isValid("nthPixel", (Number)value)) {
            this.m_NthPixel = value;
            this.reset();
        }
    }

    public int getNthPixel() {
        return this.m_NthPixel;
    }

    public String nthPixelTipText() {
        return "Only every n-th pixel will be output.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"nthPixel", (Object)this.m_NthPixel, (String)"nth: ");
    }

    protected BufferedImageContainer[] doTransform(BufferedImageContainer img) {
        BufferedImageContainer[] result = new BufferedImageContainer[]{(BufferedImageContainer)img.getHeader()};
        BufferedImage large = BufferedImageHelper.convert((BufferedImage)((BufferedImage)img.getImage()), (int)2);
        BufferedImage small = new BufferedImage(large.getWidth() / this.m_NthPixel, large.getHeight() / this.m_NthPixel, 2);
        result[0].setImage((Object)small);
        for (int x = 0; x <= large.getWidth() - this.m_NthPixel; x += this.m_NthPixel) {
            for (int y = 0; y <= large.getHeight() - this.m_NthPixel; y += this.m_NthPixel) {
                small.setRGB(x / this.m_NthPixel, y / this.m_NthPixel, large.getRGB(x, y));
            }
        }
        return result;
    }
}

