/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.image.BufferedImageContainer;
import adams.data.image.transformer.AbstractBufferedImageTransformer;
import adams.data.objectfinder.AllFinder;
import adams.data.objectfinder.ObjectFinder;
import adams.data.report.Report;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;

public class FixObjects
extends AbstractBufferedImageTransformer {
    private static final long serialVersionUID = 2959486760492196174L;
    protected ObjectFinder m_Finder;

    public String globalInfo() {
        return "Ensures that no invalid object shapes are present in the report.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("finder", "finder", (Object)new AllFinder());
    }

    public void setFinder(ObjectFinder value) {
        this.m_Finder = value;
        this.reset();
    }

    public ObjectFinder getFinder() {
        return this.m_Finder;
    }

    public String finderTipText() {
        return "The object finder to use.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"finder", (Object)this.m_Finder);
    }

    protected BufferedImageContainer[] doTransform(BufferedImageContainer img) {
        LocatedObjects objects = this.m_Finder.findObjects(img.getReport());
        for (LocatedObject obj : objects) {
            obj.makeFit(img.getWidth(), img.getHeight());
        }
        Report newReport = objects.toReport(this.m_Finder.getPrefix());
        newReport.mergeWith(img.getReport());
        img.setReport(newReport);
        return new BufferedImageContainer[]{img};
    }
}

