/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.transformer;

import adams.core.Utils;
import adams.core.base.BaseColor;
import adams.data.image.BufferedImageContainer;
import adams.data.image.transformer.AbstractBufferedImageTransformer;
import gnu.trove.map.hash.TIntIntHashMap;
import java.awt.Color;
import java.awt.image.BufferedImage;

public class ReplaceColors
extends AbstractBufferedImageTransformer {
    private static final long serialVersionUID = -7828174332731436229L;
    protected BaseColor[] m_OldColors;
    protected BaseColor[] m_NewColors;

    public String globalInfo() {
        return "Allows replacing one color with another.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("old-color", "oldColors", (Object)new BaseColor[0]);
        this.m_OptionManager.add("new-color", "newColors", (Object)new BaseColor[0]);
    }

    public void setOldColors(BaseColor[] value) {
        this.m_OldColors = value;
        this.m_NewColors = (BaseColor[])Utils.adjustArray((Object)this.m_NewColors, (int)this.m_OldColors.length, (Object)new BaseColor(Color.BLACK));
        this.reset();
    }

    public BaseColor[] getOldColors() {
        return this.m_OldColors;
    }

    public String oldColorsTipText() {
        return "The old colors to replace.";
    }

    public void setNewColors(BaseColor[] value) {
        this.m_NewColors = value;
        this.m_OldColors = (BaseColor[])Utils.adjustArray((Object)this.m_OldColors, (int)this.m_NewColors.length, (Object)new BaseColor(Color.BLACK));
        this.reset();
    }

    public BaseColor[] getNewColors() {
        return this.m_NewColors;
    }

    public String newColorsTipText() {
        return "The replacement colors.";
    }

    protected BufferedImageContainer[] doTransform(BufferedImageContainer img) {
        int i;
        TIntIntHashMap colors = new TIntIntHashMap();
        for (i = 0; i < this.m_OldColors.length; ++i) {
            colors.put(this.m_OldColors[i].toColorValue().getRGB(), this.m_NewColors[i].toColorValue().getRGB());
        }
        BufferedImageContainer[] result = new BufferedImageContainer[]{(BufferedImageContainer)img.getClone()};
        int[] pixels = ((BufferedImage)result[0].getImage()).getRGB(0, 0, ((BufferedImage)result[0].getImage()).getWidth(), ((BufferedImage)result[0].getImage()).getHeight(), null, 0, ((BufferedImage)result[0].getImage()).getWidth());
        for (i = 0; i < pixels.length; ++i) {
            if (!colors.containsKey(pixels[i])) continue;
            pixels[i] = colors.get(pixels[i]);
        }
        ((BufferedImage)result[0].getImage()).setRGB(0, 0, ((BufferedImage)result[0].getImage()).getWidth(), ((BufferedImage)result[0].getImage()).getHeight(), pixels, 0, ((BufferedImage)result[0].getImage()).getWidth());
        return result;
    }
}

