/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.image.BufferedImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.image.transformer.AbstractBufferedImageTransformer;
import java.awt.Color;
import java.awt.image.BufferedImage;

public class ThresholdReplacement
extends AbstractBufferedImageTransformer {
    private static final long serialVersionUID = 2959486760492196174L;
    protected int m_Threshold;
    protected ThresholdType m_Type;
    protected Color m_ReplacementColor;

    public String globalInfo() {
        return "Replaces pixels of the image that fall below or above (depending on configuration) a user defined threshold in the grayscale space with the supplied replacement color.\nCan be replaced to remove dark or light splotches.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("threshold", "threshold", (Object)128, (Number)0, (Number)255);
        this.m_OptionManager.add("type", "type", (Object)ThresholdType.REMOVE_BELOW);
        this.m_OptionManager.add("replacement-color", "replacementColor", (Object)Color.WHITE);
    }

    public void setThreshold(int value) {
        if (this.getOptionManager().isValid("threshold", (Number)value)) {
            this.m_Threshold = value;
            this.reset();
        }
    }

    public int getThreshold() {
        return this.m_Threshold;
    }

    public String thresholdTipText() {
        return "The threshold (in grayscale space) that determines whether pixel gets replaced.";
    }

    public void setType(ThresholdType value) {
        this.m_Type = value;
        this.reset();
    }

    public ThresholdType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "Defines how the threshold is interpreted.";
    }

    public void setReplacementColor(Color value) {
        this.m_ReplacementColor = value;
        this.reset();
    }

    public Color getReplacementColor() {
        return this.m_ReplacementColor;
    }

    public String replacementColorTipText() {
        return "The color to use as replacement.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"threshold", (Object)this.m_Threshold, (String)"threshold: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"type", (Object)((Object)this.m_Type), (String)", type: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"replacementColor", (Object)this.m_ReplacementColor, (String)", color: ");
        return result;
    }

    protected BufferedImageContainer[] doTransform(BufferedImageContainer img) {
        int width = img.getWidth();
        int height = img.getHeight();
        BufferedImageContainer[] result = new BufferedImageContainer[]{(BufferedImageContainer)img.getHeader()};
        BufferedImage imageGray = BufferedImageHelper.convert((BufferedImage)((BufferedImage)img.getImage()), (int)10);
        BufferedImage imageNew = BufferedImageHelper.deepCopy((BufferedImage)((BufferedImage)img.getImage()));
        int replace = this.m_ReplacementColor.getRGB();
        for (int y = 0; y < height; ++y) {
            block5: for (int x = 0; x < width; ++x) {
                int[] channels = BufferedImageHelper.split((int)imageGray.getRGB(x, y));
                switch (this.m_Type) {
                    case REMOVE_ABOVE: {
                        if (channels[0] <= this.m_Threshold) continue block5;
                        imageNew.setRGB(x, y, replace);
                        continue block5;
                    }
                    case REMOVE_BELOW: {
                        if (channels[0] >= this.m_Threshold) continue block5;
                        imageNew.setRGB(x, y, replace);
                    }
                }
            }
        }
        result[0].setImage((Object)imageNew);
        return result;
    }

    public static enum ThresholdType {
        REMOVE_BELOW,
        REMOVE_ABOVE;

    }
}

