/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.transformer;

import adams.data.image.BufferedImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.image.transformer.AbstractBufferedImageTransformer;
import adams.gui.visualization.core.ColorProvider;
import adams.gui.visualization.core.CustomColorProvider;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Arrays;

public class TrimapColorizer
extends AbstractBufferedImageTransformer {
    private static final long serialVersionUID = 4183676541160281269L;
    protected ColorProvider m_ColorProvider;

    public String globalInfo() {
        return "Colorizes trimap images using the specified color provider.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("color-provider", "colorProvider", (Object)this.getDefaultColorProvider());
    }

    protected ColorProvider getDefaultColorProvider() {
        CustomColorProvider result = new CustomColorProvider();
        result.setColors(new Color[]{Color.YELLOW, Color.BLUE, Color.RED});
        return result;
    }

    public void setColorProvider(ColorProvider value) {
        this.m_ColorProvider = value;
        this.reset();
    }

    public ColorProvider getColorProvider() {
        return this.m_ColorProvider;
    }

    public String colorProviderTipText() {
        return "The color provider to use for coloring in the trimap image.";
    }

    protected BufferedImageContainer[] doTransform(BufferedImageContainer img) {
        BufferedImageContainer[] result = new BufferedImageContainer[]{(BufferedImageContainer)img.getHeader()};
        int[] oldPixels = BufferedImageHelper.getPixels((BufferedImage)((BufferedImage)img.getContent()));
        TIntHashSet unique = new TIntHashSet(oldPixels);
        if (this.isLoggingEnabled()) {
            this.getLogger().info("# unique colors: " + unique.size());
        }
        this.m_ColorProvider.resetColors();
        int[] colors = unique.toArray();
        Arrays.sort(colors);
        TIntIntHashMap map = new TIntIntHashMap();
        for (int color : colors) {
            map.put(color, this.m_ColorProvider.next().getRGB());
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().info("color map: " + map);
        }
        int[] newPixels = new int[oldPixels.length];
        for (int i = 0; i < oldPixels.length; ++i) {
            newPixels[i] = map.get(oldPixels[i]);
        }
        BufferedImage newImg = new BufferedImage(img.getWidth(), img.getHeight(), 1);
        newImg.setRGB(0, 0, img.getWidth(), img.getHeight(), newPixels, 0, img.getWidth());
        result[0].setContent((Object)newImg);
        return result;
    }
}

