/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.transformer.crop;

import adams.core.Utils;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.image.transformer.AbstractBufferedImageTransformer;
import adams.data.image.transformer.PassThrough;
import adams.data.image.transformer.crop.AbstractCropAlgorithm;
import java.awt.Point;
import java.awt.image.BufferedImage;

public class BinaryCrop
extends AbstractCropAlgorithm {
    private static final long serialVersionUID = -696539737461589970L;
    protected AbstractBufferedImageTransformer m_ImageTransformer;
    protected int m_NumCheckPoints;
    protected boolean m_Invert;

    public String globalInfo() {
        return "Turns image into binary (ie black and white) image and determines the largest rectangle encompassing a (white) object in the middle to crop to.\nWhen looking for a black object, check the 'invert' option.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("image-transformer", "imageTransformer", (Object)new PassThrough());
        this.m_OptionManager.add("num-check-points", "numCheckPoints", (Object)1, (Number)1, null);
        this.m_OptionManager.add("invert", "invert", (Object)false);
    }

    public void setImageTransformer(AbstractBufferedImageTransformer value) {
        this.m_ImageTransformer = value;
        this.reset();
    }

    public AbstractBufferedImageTransformer getImageTransformer() {
        return this.m_ImageTransformer;
    }

    public String imageTransformerTipText() {
        return "The image transformer to apply to the image copy before further binarizing and determining the crop.";
    }

    public void setNumCheckPoints(int value) {
        if (this.getOptionManager().isValid("numCheckPoints", (Number)value)) {
            this.m_NumCheckPoints = value;
            this.reset();
        }
    }

    public int getNumCheckPoints() {
        return this.m_NumCheckPoints;
    }

    public String numCheckPointsTipText() {
        return "The number of check points (evenly distributed across width/height) to use for locating the smallest rectangle in the middle.";
    }

    public void setInvert(boolean value) {
        this.m_Invert = value;
        this.reset();
    }

    public boolean getInvert() {
        return this.m_Invert;
    }

    public String invertTipText() {
        return "If enabled, the algorithm looks for a black rectangle rather than a white one.";
    }

    protected int min(int[] values, int lowerBound) {
        int result = -1;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] <= lowerBound || result != -1 && values[i] >= result) continue;
            result = values[i];
        }
        if (result == -1) {
            result = lowerBound;
        }
        return result;
    }

    protected int max(int[] values, int upperBound) {
        int result = -1;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] >= upperBound || result != -1 && values[i] <= result) continue;
            result = values[i];
        }
        if (result == -1) {
            result = upperBound;
        }
        return result;
    }

    @Override
    protected BufferedImage doCrop(BufferedImage img) {
        int n;
        BufferedImageContainer cont = new BufferedImageContainer();
        cont.setContent((Object)img);
        BufferedImage binary = (BufferedImage)((BufferedImageContainer[])this.m_ImageTransformer.transform((AbstractImageContainer)cont))[0].getContent();
        binary = BufferedImageHelper.convert((BufferedImage)binary, (int)12);
        int width = img.getWidth();
        int height = img.getHeight();
        int[] xCheck = new int[this.m_NumCheckPoints];
        int[] yCheck = new int[this.m_NumCheckPoints];
        int[] top = new int[this.m_NumCheckPoints];
        int[] bottom = new int[this.m_NumCheckPoints];
        int[] left = new int[this.m_NumCheckPoints];
        int[] right = new int[this.m_NumCheckPoints];
        for (n = 0; n < this.m_NumCheckPoints; ++n) {
            xCheck[n] = width / (this.m_NumCheckPoints + 1) * (n + 1);
            yCheck[n] = height / (this.m_NumCheckPoints + 1) * (n + 1);
        }
        block1: for (n = 0; n < this.m_NumCheckPoints; ++n) {
            int value;
            int i;
            top[n] = 0;
            for (i = 0; i < height / 2; ++i) {
                value = binary.getRGB(xCheck[n], i) & 0xFF;
                if ((!this.m_Invert || value != 0) && (this.m_Invert || value <= 0)) continue;
                top[n] = i;
                break;
            }
            bottom[n] = height - 1;
            for (i = height - 1; i >= height / 2; --i) {
                value = binary.getRGB(xCheck[n], i) & 0xFF;
                if ((!this.m_Invert || value != 0) && (this.m_Invert || value <= 0)) continue;
                bottom[n] = i;
                break;
            }
            left[n] = 0;
            for (i = 0; i < width / 2; ++i) {
                value = binary.getRGB(i, yCheck[n]) & 0xFF;
                if ((!this.m_Invert || value != 0) && (this.m_Invert || value <= 0)) continue;
                left[n] = i;
                break;
            }
            right[n] = width - 1;
            for (i = width - 1; i >= width / 2; --i) {
                value = binary.getRGB(i, yCheck[n]) & 0xFF;
                if ((!this.m_Invert || value != 0) && (this.m_Invert || value <= 0)) continue;
                right[n] = i;
                continue block1;
            }
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("top...: " + Utils.arrayToString((Object)top));
            this.getLogger().fine("left..: " + Utils.arrayToString((Object)left));
            this.getLogger().fine("bottom: " + Utils.arrayToString((Object)bottom));
            this.getLogger().fine("right.: " + Utils.arrayToString((Object)right));
        }
        int aleft = this.min(left, 0);
        int aright = this.max(right, width - 1);
        int atop = this.min(top, 0);
        int abottom = this.max(bottom, height - 1);
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("-> top...: " + atop);
            this.getLogger().fine("-> left..: " + aleft);
            this.getLogger().fine("-> bottom: " + abottom);
            this.getLogger().fine("-> right.: " + aright);
        }
        this.m_TopLeft = new Point(aleft, atop);
        this.m_BottomRight = new Point(aright, abottom);
        BufferedImage image = img.getSubimage(aleft, atop, aright - aleft + 1, abottom - atop + 1);
        return image;
    }
}

