/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.transformer.subimages;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.image.BufferedImageContainer;
import adams.data.image.transformer.subimages.AbstractSubImagesGenerator;
import adams.data.objectfinder.AllFinder;
import adams.data.objectfinder.ObjectFinder;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public class Objects
extends AbstractSubImagesGenerator {
    private static final long serialVersionUID = 2488185528644078539L;
    protected ObjectFinder m_Finder;

    public String globalInfo() {
        return "Extracts sub-images defined by the objects that the object finder locates.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("finder", "finder", (Object)new AllFinder());
    }

    public void setFinder(ObjectFinder value) {
        this.m_Finder = value;
        this.reset();
    }

    public ObjectFinder getFinder() {
        return this.m_Finder;
    }

    public String finderTipText() {
        return "The object finder to use.";
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"finder", (Object)this.m_Finder, (String)", finder: ");
        return result;
    }

    @Override
    protected List<BufferedImageContainer> doProcess(BufferedImageContainer image) {
        ArrayList<BufferedImageContainer> result = new ArrayList<BufferedImageContainer>();
        LocatedObjects objs = LocatedObjects.fromReport(image.getReport(), this.m_Finder.getPrefix());
        BufferedImage bimage = (BufferedImage)image.getImage();
        for (LocatedObject obj : objs) {
            boolean modified = obj.makeFit(bimage.getWidth(), bimage.getHeight());
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Object #" + obj.getIndexString() + ": " + obj + " (modified=" + modified + ")");
            }
            BufferedImageContainer cont = (BufferedImageContainer)image.getHeader();
            cont.setReport(this.transferObjects(cont.getReport(), obj.getX(), obj.getY(), obj.getWidth(), obj.getHeight()));
            cont.setImage((Object)bimage.getSubimage(obj.getX(), obj.getY(), obj.getWidth(), obj.getHeight()));
            result.add(cont);
        }
        return result;
    }
}

