/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.Utils;
import adams.core.base.BaseString;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.data.image.BufferedImageHelper;
import adams.data.io.input.AbstractImageSegmentationAnnotationReader;
import adams.data.io.output.AbstractImageSegmentationAnnotationWriter;
import adams.data.io.output.BlueChannelImageSegmentationWriter;
import adams.data.statistics.StatUtils;
import adams.flow.container.ImageSegmentationContainer;
import gnu.trove.set.hash.TIntHashSet;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;

public class BlueChannelImageSegmentationReader
extends AbstractImageSegmentationAnnotationReader {
    private static final long serialVersionUID = -5567473437385041915L;
    protected boolean m_SkipFirstLayer;
    protected BaseString[] m_LayerNames;

    public String globalInfo() {
        return "The layers are stored in the blue channel, with 0 being the background.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("skip-first-layer", "skipFirstLayer", (Object)true);
        this.m_OptionManager.add("layer-name", "layerNames", (Object)new BaseString[0]);
    }

    public void setSkipFirstLayer(boolean value) {
        this.m_SkipFirstLayer = value;
        this.reset();
    }

    public boolean getSkipFirstLayer() {
        return this.m_SkipFirstLayer;
    }

    public String skipFirstLayerTipText() {
        return "If enabled, the first layer gets skipped (usually the background).";
    }

    public void setLayerNames(BaseString[] value) {
        this.m_LayerNames = value;
        this.reset();
    }

    public BaseString[] getLayerNames() {
        return this.m_LayerNames;
    }

    public String layerNamesTipText() {
        return "The names to use for the layers; if additional layers should be present in the data, names get assigned automatically.";
    }

    @Override
    public AbstractImageSegmentationAnnotationWriter getCorrespondingWriter() {
        return new BlueChannelImageSegmentationWriter();
    }

    public String getFormatDescription() {
        return "Blue channel image segmentation";
    }

    public String[] getFormatExtensions() {
        return new String[]{"jpg"};
    }

    public String getDefaultFormatExtension() {
        return "jpg";
    }

    @Override
    protected String check(PlaceholderFile file) {
        PlaceholderFile png;
        String result = super.check(file);
        if (result == null && !(png = FileUtils.replaceExtension((PlaceholderFile)file, (String)".png")).exists()) {
            result = "Associated PNG file with annotations is missing!";
        }
        return result;
    }

    @Override
    protected ImageSegmentationContainer doRead(PlaceholderFile file) {
        int n;
        int i;
        BufferedImage baseImage = BufferedImageHelper.read((File)file).toBufferedImage();
        PlaceholderFile png = FileUtils.replaceExtension((PlaceholderFile)file, (String)".png");
        BufferedImage pngImage = BufferedImageHelper.read((File)png).toBufferedImage();
        int[] pngPixels = BufferedImageHelper.getPixels((BufferedImage)pngImage);
        int[] unique = StatUtils.uniqueValues((int[])pngPixels);
        Arrays.sort(unique);
        int[] uniqueBlue = new int[unique.length];
        int maxLayer = 0;
        for (i = 0; i < unique.length; ++i) {
            uniqueBlue[i] = unique[i] & 0xFF;
            maxLayer = Math.max(maxLayer, uniqueBlue[i]);
        }
        TIntHashSet uniqueBlueSet = new TIntHashSet(uniqueBlue);
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Unique colors: #=" + unique.length + ", values=" + Utils.arrayToString((Object)unique) + ", blue=" + Utils.arrayToString((Object)uniqueBlue));
        }
        int white = Color.WHITE.getRGB();
        int[][] layerPixels = new int[maxLayer + 1][pngPixels.length];
        for (n = 0; n <= maxLayer; ++n) {
            for (i = 0; i < pngPixels.length; ++i) {
                if ((pngPixels[i] & 0xFF) != n) continue;
                layerPixels[n][i] = white;
            }
        }
        HashMap<String, BufferedImage> layerImages = new HashMap<String, BufferedImage>();
        n = 0;
        for (i = 0; i <= maxLayer; ++i) {
            if (this.m_SkipFirstLayer && i == 0) continue;
            String layerName = n < this.m_LayerNames.length ? this.m_LayerNames[n].getValue() : "layer-" + (n + 1);
            if (uniqueBlueSet.contains(i)) {
                layerImages.put(layerName, new BufferedImage(baseImage.getWidth(), baseImage.getHeight(), 1));
                ((BufferedImage)layerImages.get(layerName)).setRGB(0, 0, baseImage.getWidth(), baseImage.getHeight(), layerPixels[i], 0, baseImage.getWidth());
            }
            ++n;
        }
        ImageSegmentationContainer result = new ImageSegmentationContainer(file.getName(), baseImage, layerImages);
        return result;
    }
}

