/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.annotation.DeprecatedClass;
import adams.core.io.FileUtils;
import adams.data.io.input.AbstractReportReader;
import adams.data.io.input.CocoAnnotationsReportReader;
import adams.data.report.Report;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import adams.flow.transformer.locateobjects.ObjectPrefixHandler;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;

@DeprecatedClass(useInstead={CocoAnnotationsReportReader.class})
public class DetectronAnnotationsReportReader
extends AbstractReportReader<Report>
implements ObjectPrefixHandler {
    private static final long serialVersionUID = 5716807404370681434L;
    protected String m_Prefix;
    protected String m_LabelKey;

    public String globalInfo() {
        return "Interprets rectangle annotations present in Detectron annotations JSON file.\n";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("prefix", "prefix", (Object)"Object.");
        this.m_OptionManager.add("label-key", "labelKey", (Object)"");
    }

    @Override
    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    @Override
    public String getPrefix() {
        return this.m_Prefix;
    }

    @Override
    public String prefixTipText() {
        return "The report field prefix used in the report.";
    }

    public void setLabelKey(String value) {
        this.m_LabelKey = value;
        this.reset();
    }

    public String getLabelKey() {
        return this.m_LabelKey;
    }

    public String labelKeyTipText() {
        return "The key in the meta-data containing the label, ignored if empty.";
    }

    public String getFormatDescription() {
        return "Detectron Annotations JSON";
    }

    public String[] getFormatExtensions() {
        return new String[]{"json"};
    }

    protected int determineParentID(Report report) {
        return -1;
    }

    public Report newInstance() {
        return new Report();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Report> readData() {
        ArrayList<Report> result = new ArrayList<Report>();
        FileReader freader = null;
        BufferedReader breader = null;
        try {
            freader = new FileReader(this.m_Input.getAbsolutePath());
            breader = new BufferedReader(freader);
            JSONParser parser = new JSONParser(1984);
            JSONObject obj = (JSONObject)parser.parse((Reader)breader);
            JSONArray categories = (JSONArray)obj.get((Object)"categories");
            JSONArray images = (JSONArray)obj.get((Object)"images");
            JSONArray annotations = (JSONArray)obj.get((Object)"annotations");
            String[] labels = new String[categories.size()];
            for (int ca = 0; ca < categories.size(); ++ca) {
                JSONObject category = (JSONObject)categories.get(ca);
                labels[ca] = category.getAsString("name");
            }
            for (int im = 0; im < images.size(); ++im) {
                JSONObject img = (JSONObject)images.get(im);
                String fname = img.getAsString("file_name");
                LocatedObjects lobjs = new LocatedObjects();
                for (int an = 0; an < annotations.size(); ++an) {
                    JSONObject region = (JSONObject)annotations.get(an);
                    if (region.getAsNumber("image_id").intValue() != im + 1) continue;
                    JSONArray bbox = (JSONArray)region.get((Object)"bbox");
                    double x = (Double)bbox.get(0);
                    double y = (Double)bbox.get(1);
                    double width = (Double)bbox.get(2);
                    double height = (Double)bbox.get(3);
                    LocatedObject lobj = new LocatedObject((int)x, (int)y, (int)width, (int)height);
                    String label = null;
                    if (region.getAsNumber("category_id") != null) {
                        label = labels[region.getAsNumber("category_id").intValue() - 1];
                    }
                    lobj.getMetaData().put("filename", fname);
                    if (label != null) {
                        lobj.getMetaData().put(this.m_LabelKey, label);
                    }
                    lobjs.add(lobj);
                }
                result.add(lobjs.toReport(this.m_Prefix));
            }
        }
        catch (Exception e) {
            try {
                this.getLogger().log(Level.SEVERE, "Failed to read JSON file: " + this.m_Input, (Throwable)e);
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(breader);
                FileUtils.closeQuietly(freader);
                throw throwable;
            }
            FileUtils.closeQuietly((Reader)breader);
            FileUtils.closeQuietly((Reader)freader);
        }
        FileUtils.closeQuietly((Reader)breader);
        FileUtils.closeQuietly((Reader)freader);
        return result;
    }
}

