/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.Utils;
import adams.data.io.input.AbstractReportReader;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.report.Report;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import gnu.trove.list.array.TIntArrayList;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ImageClassificationGridSpreadSheetReader
extends AbstractReportReader<Report> {
    private static final long serialVersionUID = 2621489607429248730L;
    protected int m_Width;
    protected int m_Height;

    public String globalInfo() {
        return "Turns grid cells in the spreadsheet with labels ('label=score') into object locations.\nSpreadsheet format:\ny,x,label1,label2,...\n0,0,cat=0.98,,...\n0,1,,,...\n0,2,dog=0.9,cat=0.2,...";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("width", "width", (Object)1000, (Number)1, null);
        this.m_OptionManager.add("height", "height", (Object)1000, (Number)1, null);
    }

    public void setWidth(int value) {
        this.m_Width = value;
        this.reset();
    }

    public int getWidth() {
        return this.m_Width;
    }

    public String widthTipText() {
        return "The width to use.";
    }

    public void setHeight(int value) {
        this.m_Height = value;
        this.reset();
    }

    public int getHeight() {
        return this.m_Height;
    }

    public String heightTipText() {
        return "The height to use.";
    }

    public String getFormatDescription() {
        return "Image classification grid";
    }

    public String[] getFormatExtensions() {
        return new String[]{"csv"};
    }

    protected int determineParentID(Report report) {
        return -1;
    }

    public Report newInstance() {
        return new Report();
    }

    protected List<Report> readData() {
        int y;
        int x;
        int i;
        ArrayList<Report> result = new ArrayList<Report>();
        CsvSpreadSheetReader reader = new CsvSpreadSheetReader();
        SpreadSheet sheet = reader.read((File)this.m_Input);
        if (sheet == null) {
            this.getLogger().severe("Failed to read spreadsheet: " + this.m_Input);
            return result;
        }
        SpreadSheetColumnIndex index = new SpreadSheetColumnIndex("x");
        index.setData((Object)sheet);
        int colX = index.getIntIndex();
        if (colX == -1) {
            this.getLogger().severe("Failed to locate column: " + index.getIndex());
            return result;
        }
        index = new SpreadSheetColumnIndex("y");
        index.setData((Object)sheet);
        int colY = index.getIntIndex();
        if (colY == -1) {
            this.getLogger().severe("Failed to locate column: " + index.getIndex());
            return result;
        }
        TIntArrayList colLabels = new TIntArrayList();
        for (i = 0; i < sheet.getColumnCount(); ++i) {
            if (i == colX || i == colY) continue;
            colLabels.add(i);
        }
        ArrayList<String> labels = new ArrayList<String>();
        int numCols = -1;
        int numRows = -1;
        for (Row row : sheet.rows()) {
            labels.clear();
            if (!row.hasCell(colX) || !row.hasCell(colY) || !row.getCell(colX).isLong() || !row.getCell(colY).isLong()) continue;
            x = row.getCell(colX).toLong().intValue();
            y = row.getCell(colY).toLong().intValue();
            numCols = Math.max(x, numCols);
            numRows = Math.max(y, numRows);
        }
        int cellWidth = Math.round(this.m_Width / ++numCols);
        int cellHeight = Math.round(this.m_Height / ++numRows);
        LocatedObjects objects = new LocatedObjects();
        for (Row row : sheet.rows()) {
            if (!row.hasCell(colX) || !row.hasCell(colY) || !row.getCell(colX).isLong() || !row.getCell(colY).isLong()) continue;
            x = row.getCell(colX).toLong().intValue();
            y = row.getCell(colY).toLong().intValue();
            labels.clear();
            for (i = 0; i < colLabels.size(); ++i) {
                if (row.getCell(colLabels.get(i)).isMissing() || row.getCell(colLabels.get(i)).getContent().trim().isEmpty()) continue;
                labels.add(row.getCell(colLabels.get(i)).getContent().trim());
            }
            if (labels.size() <= 0) continue;
            String labelHighest = "";
            double scoreHighest = 0.0;
            for (String l : labels) {
                String[] parts;
                if (!l.contains("=") || (parts = l.split("=")).length != 2 || !Utils.isDouble((String)parts[1])) continue;
                String label = parts[0];
                double score = Double.parseDouble(parts[1]);
                if (!(score > scoreHighest)) continue;
                scoreHighest = score;
                labelHighest = label;
            }
            if (labelHighest.isEmpty()) continue;
            LocatedObject object = new LocatedObject(x * cellWidth, y * cellHeight, cellWidth, cellHeight);
            object.getMetaData().put("type", labelHighest);
            object.getMetaData().put("score", scoreHighest);
            object.getMetaData().put("labels", Utils.flatten(labels, (String)","));
            objects.add(object);
        }
        result.add(objects.toReport("Object."));
        return result;
    }
}

