/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.data.io.input.AbstractReportReader;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.io.input.SpreadSheetReader;
import adams.data.report.Report;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.data.spreadsheet.rowfinder.AbstractRowFinder;
import adams.data.spreadsheet.rowfinder.AllFinder;
import adams.data.spreadsheet.rowfinder.RowFinder;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import adams.flow.transformer.locateobjects.ObjectPrefixHandler;
import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.set.hash.TIntHashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class ObjectLocationsSpreadSheetReader
extends AbstractReportReader<Report>
implements ObjectPrefixHandler {
    private static final long serialVersionUID = -45890668031870078L;
    protected SpreadSheetReader m_Reader;
    protected RowFinder m_RowFinder;
    protected SpreadSheetColumnIndex m_ColLeft;
    protected SpreadSheetColumnIndex m_ColTop;
    protected SpreadSheetColumnIndex m_ColRight;
    protected SpreadSheetColumnIndex m_ColBottom;
    protected SpreadSheetColumnIndex m_ColWidth;
    protected SpreadSheetColumnIndex m_ColHeight;
    protected SpreadSheetColumnIndex m_ColPolygonX;
    protected SpreadSheetColumnIndex m_ColPolygonY;
    protected SpreadSheetColumnIndex m_ColType;
    protected SpreadSheetColumnRange m_RangeMetaData;
    protected boolean m_UseNormalized;
    protected int m_Width;
    protected int m_Height;
    protected String m_Prefix;
    protected String m_LabelSuffix;

    public String globalInfo() {
        return "Reads object locations from a spreadsheet into a report.\nTop/left column is required.\nEither right/bottom or width/height need to be supplied.\nIn addition, polygon coordinates (X and Y coordinates as comma-separated lists in two separate columns) can be read as well.\nIf the coordinates/dimensions represent normalized ones (ie 0-1), then specify the width/height of the image to relate them back to actual pixel-based sizes.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("reader", "reader", (Object)new CsvSpreadSheetReader());
        this.m_OptionManager.add("row-finder", "rowFinder", (Object)new AllFinder());
        this.m_OptionManager.add("col-left", "colLeft", (Object)new SpreadSheetColumnIndex());
        this.m_OptionManager.add("col-top", "colTop", (Object)new SpreadSheetColumnIndex());
        this.m_OptionManager.add("col-right", "colRight", (Object)new SpreadSheetColumnIndex());
        this.m_OptionManager.add("col-bottom", "colBottom", (Object)new SpreadSheetColumnIndex());
        this.m_OptionManager.add("col-width", "colWidth", (Object)new SpreadSheetColumnIndex());
        this.m_OptionManager.add("col-height", "colHeight", (Object)new SpreadSheetColumnIndex());
        this.m_OptionManager.add("col-polygon-x", "colPolygonX", (Object)new SpreadSheetColumnIndex());
        this.m_OptionManager.add("col-polygon-y", "colPolygonY", (Object)new SpreadSheetColumnIndex());
        this.m_OptionManager.add("col-type", "colType", (Object)new SpreadSheetColumnIndex());
        this.m_OptionManager.add("range-meta-data", "rangeMetaData", (Object)new SpreadSheetColumnRange());
        this.m_OptionManager.add("use-normalized", "useNormalized", (Object)false);
        this.m_OptionManager.add("width", "width", (Object)1000, (Number)1, null);
        this.m_OptionManager.add("height", "height", (Object)1000, (Number)1, null);
        this.m_OptionManager.add("prefix", "prefix", (Object)"Object.");
        this.m_OptionManager.add("label-suffix", "labelSuffix", (Object)"type");
    }

    public void setReader(SpreadSheetReader value) {
        this.m_Reader = value;
        this.reset();
    }

    public SpreadSheetReader getReader() {
        return this.m_Reader;
    }

    public String readerTipText() {
        return "The reader to use for reading the spreadsheet data.";
    }

    public void setRowFinder(RowFinder value) {
        this.m_RowFinder = value;
        this.reset();
    }

    public RowFinder getRowFinder() {
        return this.m_RowFinder;
    }

    public String rowFinderTipText() {
        return "The row finder to use for selecting a subset before extracting object locations.";
    }

    public void setColLeft(SpreadSheetColumnIndex value) {
        this.m_ColLeft = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getColLeft() {
        return this.m_ColLeft;
    }

    public String colLeftTipText() {
        return "The column containing the left coordinate.";
    }

    public void setColTop(SpreadSheetColumnIndex value) {
        this.m_ColTop = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getColTop() {
        return this.m_ColTop;
    }

    public String colTopTipText() {
        return "The column containing the top coordinate.";
    }

    public void setColRight(SpreadSheetColumnIndex value) {
        this.m_ColRight = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getColRight() {
        return this.m_ColRight;
    }

    public String colRightTipText() {
        return "The column containing the right coordinate.";
    }

    public void setColBottom(SpreadSheetColumnIndex value) {
        this.m_ColBottom = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getColBottom() {
        return this.m_ColBottom;
    }

    public String colBottomTipText() {
        return "The column containing the bottom coordinate.";
    }

    public void setColWidth(SpreadSheetColumnIndex value) {
        this.m_ColWidth = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getColWidth() {
        return this.m_ColWidth;
    }

    public String colWidthTipText() {
        return "The column containing the width coordinate.";
    }

    public void setColHeight(SpreadSheetColumnIndex value) {
        this.m_ColHeight = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getColHeight() {
        return this.m_ColHeight;
    }

    public String colHeightTipText() {
        return "The column containing the height coordinate.";
    }

    public void setColPolygonX(SpreadSheetColumnIndex value) {
        this.m_ColPolygonX = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getColPolygonX() {
        return this.m_ColPolygonX;
    }

    public String colPolygonXTipText() {
        return "The column containing the X coordinates of the polygon (comma-separated list of coordinates); cannot be used without bounding box.";
    }

    public void setColPolygonY(SpreadSheetColumnIndex value) {
        this.m_ColPolygonY = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getColPolygonY() {
        return this.m_ColPolygonY;
    }

    public String colPolygonYTipText() {
        return "The column containing the Y coordinates of the polygon (comma-separated list of coordinates); cannot be used without bounding box.";
    }

    public void setColType(SpreadSheetColumnIndex value) {
        this.m_ColType = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getColType() {
        return this.m_ColType;
    }

    public String colTypeTipText() {
        return "The column containing the object label.";
    }

    public void setUseNormalized(boolean value) {
        this.m_UseNormalized = value;
        this.reset();
    }

    public boolean getUseNormalized() {
        return this.m_UseNormalized;
    }

    public String useNormalizedTipText() {
        return "If enabled, the coordinates/dimensions are interpreted as normalized (0-1) rather than absolute pixels.";
    }

    public void setWidth(int value) {
        this.m_Width = value;
        this.reset();
    }

    public int getWidth() {
        return this.m_Width;
    }

    public String widthTipText() {
        return "The width of the image to use when reading normalized coordinates/dimensions.";
    }

    public void setHeight(int value) {
        this.m_Height = value;
        this.reset();
    }

    public int getHeight() {
        return this.m_Height;
    }

    public String heightTipText() {
        return "The height of the image to use when reading normalized coordinates/dimensions.";
    }

    public void setRangeMetaData(SpreadSheetColumnRange value) {
        this.m_RangeMetaData = value;
        this.reset();
    }

    public SpreadSheetColumnRange getRangeMetaData() {
        return this.m_RangeMetaData;
    }

    public String rangeMetaDataTipText() {
        return "The columns to store as meta-data; all other columns get automatically excluded from the meta-data.";
    }

    @Override
    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    @Override
    public String getPrefix() {
        return this.m_Prefix;
    }

    @Override
    public String prefixTipText() {
        return "The report field prefix used in the report.";
    }

    public void setLabelSuffix(String value) {
        this.m_LabelSuffix = value;
        this.reset();
    }

    public String getLabelSuffix() {
        return this.m_LabelSuffix;
    }

    public String labelSuffixTipText() {
        return "The suffix to use in the report for labels.";
    }

    public String getFormatDescription() {
        return "Object locations";
    }

    public String[] getFormatExtensions() {
        return new String[]{"*"};
    }

    public Report newInstance() {
        return new Report();
    }

    protected int determineParentID(Report report) {
        return -1;
    }

    protected double[] parseCoords(String coords) {
        TDoubleArrayList result = new TDoubleArrayList();
        try {
            for (String coord : coords.split(",")) {
                result.add(Double.parseDouble(coord));
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to parse coordinates '" + coords + "'!", (Throwable)e);
            result = new TDoubleArrayList();
        }
        return result.toArray();
    }

    protected double[] multipleCoords(double[] coords, double factor) {
        for (int i = 0; i < coords.length; ++i) {
            coords[i] = coords[i] * factor;
        }
        return coords;
    }

    protected String coordsToList(double[] coords) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < coords.length; ++i) {
            if (i > 0) {
                result.append(",");
            }
            result.append("" + coords[i]);
        }
        return result.toString();
    }

    protected List<Report> readData() {
        ArrayList<Report> result = new ArrayList<Report>();
        SpreadSheet sheet = this.m_Reader.read((File)this.m_Input);
        if (!(this.m_RowFinder instanceof AllFinder)) {
            sheet = AbstractRowFinder.filter((SpreadSheet)sheet, (RowFinder)this.m_RowFinder);
        }
        this.m_ColLeft.setData((Object)sheet);
        int left = this.m_ColLeft.getIntIndex();
        if (left == -1) {
            this.getLogger().severe("Failed to locate 'left' column: " + this.m_ColLeft.getIndex());
            return result;
        }
        this.m_ColTop.setData((Object)sheet);
        int top = this.m_ColTop.getIntIndex();
        if (top == -1) {
            this.getLogger().severe("Failed to locate 'top' column: " + this.m_ColTop.getIndex());
            return result;
        }
        this.m_ColRight.setData((Object)sheet);
        int right = this.m_ColRight.getIntIndex();
        this.m_ColBottom.setData((Object)sheet);
        int bottom = this.m_ColBottom.getIntIndex();
        this.m_ColWidth.setData((Object)sheet);
        int width = this.m_ColWidth.getIntIndex();
        this.m_ColHeight.setData((Object)sheet);
        int height = this.m_ColHeight.getIntIndex();
        this.m_ColPolygonX.setData((Object)sheet);
        int polyX = this.m_ColPolygonX.getIntIndex();
        this.m_ColPolygonY.setData((Object)sheet);
        int polyY = this.m_ColPolygonY.getIntIndex();
        this.m_ColType.setData((Object)sheet);
        int type = this.m_ColType.getIntIndex();
        if (right == -1) {
            if (width == -1) {
                this.getLogger().severe("If 'right' column is not defined, then 'width' must be: " + this.m_ColWidth.getIndex());
                return result;
            }
        } else if (bottom == -1) {
            this.getLogger().severe("If 'right' column is defined, then 'bottom' must be as well: " + this.m_ColBottom.getIndex());
            return result;
        }
        if (bottom == -1) {
            if (height == -1) {
                this.getLogger().severe("If 'bottom' column is not defined, then 'height' must be: " + this.m_ColHeight.getIndex());
                return result;
            }
        } else if (right == -1) {
            this.getLogger().severe("If 'bottom' column is defined, then 'right' must be as well: " + this.m_ColRight.getIndex());
            return result;
        }
        this.m_RangeMetaData.setData((Object)sheet);
        int[] meta = this.m_RangeMetaData.getIntIndices();
        TIntHashSet metaSet = new TIntHashSet(meta);
        metaSet.remove(left);
        metaSet.remove(top);
        metaSet.remove(right);
        metaSet.remove(bottom);
        metaSet.remove(width);
        metaSet.remove(height);
        metaSet.remove(polyX);
        metaSet.remove(polyY);
        metaSet.remove(type);
        meta = metaSet.toArray();
        LocatedObjects objects = new LocatedObjects();
        for (Row row : sheet.rows()) {
            LocatedObject object;
            if (this.m_UseNormalized) {
                object = width != -1 ? new LocatedObject((int)(row.getCell(left).toDouble() * (double)this.m_Width), (int)(row.getCell(top).toDouble() * (double)this.m_Height), (int)(row.getCell(width).toDouble() * (double)this.m_Width), (int)(row.getCell(height).toDouble() * (double)this.m_Height)) : new LocatedObject((int)(row.getCell(left).toDouble() * (double)this.m_Width), (int)(row.getCell(top).toDouble() * (double)this.m_Height), (int)(row.getCell(right).toDouble() * (double)this.m_Width - row.getCell(left).toDouble() * (double)this.m_Width), (int)(row.getCell(bottom).toDouble() * (double)this.m_Height - row.getCell(top).toDouble() * (double)this.m_Height));
                if (polyX != -1 && row.hasCell(polyX) && !row.getCell(polyX).isMissing()) {
                    object.getMetaData().put("poly_x", this.coordsToList(this.multipleCoords(this.parseCoords(row.getCell(polyX).getContent()), this.m_Width)));
                }
                if (polyY != -1 && row.hasCell(polyY) && !row.getCell(polyY).isMissing()) {
                    object.getMetaData().put("poly_y", this.coordsToList(this.multipleCoords(this.parseCoords(row.getCell(polyY).getContent()), this.m_Height)));
                }
            } else {
                object = width != -1 ? new LocatedObject(row.getCell(left).toDouble().intValue(), row.getCell(top).toDouble().intValue(), row.getCell(width).toDouble().intValue(), row.getCell(height).toDouble().intValue()) : new LocatedObject(row.getCell(left).toDouble().intValue(), row.getCell(top).toDouble().intValue(), row.getCell(right).toDouble().intValue() - row.getCell(left).toDouble().intValue() + 1, row.getCell(bottom).toDouble().intValue() - row.getCell(top).toDouble().intValue() + 1);
                if (polyX != -1 && row.hasCell(polyX) && !row.getCell(polyX).isMissing()) {
                    object.getMetaData().put("poly_x", this.coordsToList(this.parseCoords(row.getCell(polyX).getContent())));
                }
                if (polyY != -1 && row.hasCell(polyY) && !row.getCell(polyY).isMissing()) {
                    object.getMetaData().put("poly_y", this.coordsToList(this.parseCoords(row.getCell(polyY).getContent())));
                }
            }
            for (int m : meta) {
                object.getMetaData().put(sheet.getColumnName(m), row.getCell(m).getNative());
            }
            if (type != -1) {
                object.getMetaData().put(this.m_LabelSuffix, row.getCell(type).getContent());
            }
            objects.add(object);
        }
        result.add(objects.toReport(this.m_Prefix));
        return result;
    }
}

